/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.LargeObject;
import com.impossibl.postgres.jdbc.PGBlob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class BlobOutputStream
extends OutputStream {
    PGBlob owner;
    LargeObject lo;
    byte[] buf;
    int pos;

    public BlobOutputStream(PGBlob owner, LargeObject lo) {
        this.owner = owner;
        this.lo = lo;
        this.pos = 0;
        this.buf = new byte[1024];
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos >= this.buf.length) {
            this.writeNextRegion();
        }
        this.buf[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.pos > 0) {
            this.writeNextRegion();
        }
        try {
            this.lo.write(b, off, len);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.pos > 0) {
            this.writeNextRegion();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        try {
            this.lo.close();
        }
        catch (SQLException e) {
            throw new IOException("Error closing stream", e);
        }
        if (this.owner != null) {
            this.owner.removeStream(this.lo);
        }
        this.owner = null;
        this.lo = null;
    }

    private void writeNextRegion() throws IOException {
        try {
            this.lo.write(this.buf, 0, this.pos);
            this.pos = 0;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }
}

