/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ArrayUtils;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.SQLTypeMetaData;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class PGArray
implements Array {
    PGConnectionImpl connection;
    ArrayType type;
    Object[] value;

    public PGArray(PGConnectionImpl connection, ArrayType type, Object[] value) {
        this.connection = connection;
        this.type = type;
        this.value = value;
    }

    public Object[] getValue() {
        return this.value;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.type.getElementType().getName();
    }

    @Override
    public int getBaseType() throws SQLException {
        return SQLTypeMetaData.getSQLType(this.type.getElementType());
    }

    @Override
    public Object getArray() throws SQLException {
        return this.getArray(this.connection.getTypeMap());
    }

    @Override
    public Object getArray(Map<String, Class<?>> typeMap) throws SQLException {
        Class<?> targetType = SQLTypeUtils.mapGetType(this.type, typeMap, this.connection);
        return SQLTypeUtils.coerceToArray(this.value, this.type, targetType, typeMap, this.connection);
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(index, count, this.connection.getTypeMap());
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> typeMap) throws SQLException {
        if (index < 1L || index > (long)this.value.length || index + (long)count > (long)(this.value.length + 1)) {
            throw new SQLException("Invalid array slice");
        }
        Class<?> targetType = SQLTypeUtils.mapGetType(this.type, typeMap, this.connection);
        return SQLTypeUtils.coerceToArray(this.value, (int)index - 1, count, this.type, targetType, typeMap, this.connection);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(this.connection.getTypeMap());
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet(1L, this.value.length, map);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSet(index, count, this.connection.getTypeMap());
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (index < 1L || index > (long)(this.value.length + 1) || index + (long)count > (long)(this.value.length + 1)) {
            throw new SQLException("Invalid array slice");
        }
        Registry reg = this.connection.getRegistry();
        Type elementType = ArrayUtils.getDimensions(this.value) > 1 ? this.type : this.type.getElementType();
        ResultField[] fields = new ResultField[]{new ResultField("INDEX", 0, 0, reg.loadType("int4"), 0, 0, ResultField.Format.Binary), new ResultField("VALUE", 0, 0, elementType, 0, 0, ResultField.Format.Binary)};
        ArrayList<Object[]> results = new ArrayList<Object[]>(this.value.length);
        long end = index + (long)count;
        for (long c = index; c < end; ++c) {
            results.add(new Object[]{c, this.value[(int)c - 1]});
        }
        PGStatement stmt = this.connection.createStatement();
        stmt.closeOnCompletion();
        return stmt.createResultSet(Arrays.asList(fields), results, map);
    }

    @Override
    public void free() throws SQLException {
        this.connection = null;
        this.type = null;
        this.value = null;
    }
}

