/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.SQLTypeMetaData;
import com.impossibl.postgres.types.Type;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class PGParameterMetaData
implements ParameterMetaData {
    List<Type> parameterTypes;
    Map<String, Class<?>> typeMap;

    public PGParameterMetaData(List<Type> parameterTypes, Map<String, Class<?>> typeMap) {
        this.parameterTypes = parameterTypes;
        this.typeMap = typeMap;
    }

    void checkParamIndex(int paramIndex) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.parameterTypes.size()) {
            throw Exceptions.PARAMETER_INDEX_OUT_OF_BOUNDS;
        }
    }

    Type getType(int paramIndex) throws SQLException {
        this.checkParamIndex(paramIndex);
        return this.parameterTypes.get(paramIndex - 1);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterTypes.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        Type paramType = this.getType(param);
        if (SQLTypeMetaData.isNullable(paramType) == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        Type type = this.getType(param);
        return SQLTypeMetaData.isSigned(type);
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        Type paramType = this.getType(param);
        return SQLTypeMetaData.getPrecision(paramType, 0, 0);
    }

    @Override
    public int getScale(int param) throws SQLException {
        Type paramType = this.getType(param);
        return SQLTypeMetaData.getScale(paramType, 0, 0);
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        Type paramType = this.getType(param);
        return SQLTypeMetaData.getSQLType(paramType);
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        Type paramType = this.getType(param);
        return paramType.getName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        Type paramType = this.getType(param);
        return paramType.getJavaType(paramType.getPreferredFormat(), this.typeMap).getName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 1;
    }
}

