/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.api.jdbc.PGNotificationListener;
import com.impossibl.postgres.jdbc.PGCallableStatementDelegator;
import com.impossibl.postgres.jdbc.PGPooledConnection;
import com.impossibl.postgres.jdbc.PGPreparedStatementDelegator;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.PGStatementDelegator;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class PGPooledConnectionDelegator
implements PGConnection {
    private PGPooledConnection owner;
    private PGConnection delegator;
    private boolean automatic;

    public PGPooledConnectionDelegator(PGPooledConnection owner, PGConnection delegator) {
        this.owner = owner;
        this.delegator = delegator;
        this.automatic = false;
    }

    @Override
    public boolean isServerMinimumVersion(int major, int minor) {
        try {
            this.checkClosed();
            return this.delegator.isServerMinimumVersion(major, minor);
        }
        catch (SQLException se) {
            return false;
        }
    }

    @Override
    public void addNotificationListener(String name, String channelNameFilter, PGNotificationListener listener) {
        try {
            this.checkClosed();
            this.delegator.addNotificationListener(name, channelNameFilter, listener);
        }
        catch (SQLException se) {
            // empty catch block
        }
    }

    @Override
    public void addNotificationListener(String channelNameFilter, PGNotificationListener listener) {
        try {
            this.checkClosed();
            this.delegator.addNotificationListener(channelNameFilter, listener);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void addNotificationListener(PGNotificationListener listener) {
        try {
            this.checkClosed();
            this.delegator.addNotificationListener(listener);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void removeNotificationListener(String name) {
        try {
            this.checkClosed();
            this.delegator.removeNotificationListener(name);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void removeNotificationListener(PGNotificationListener listener) {
        try {
            this.checkClosed();
            this.delegator.removeNotificationListener(listener);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.abort(executor);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.checkClosed();
            this.delegator.clearWarnings();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.delegator != null) {
            SQLException ex = null;
            if (!this.owner.isXA() && !this.delegator.getAutoCommit()) {
                try {
                    this.delegator.rollback();
                }
                catch (SQLException e) {
                    ex = e;
                }
            }
            this.delegator.clearWarnings();
            this.delegator = null;
            this.owner.setLast(null);
            this.owner.fireConnectionClosed();
            if (ex != null) {
                throw ex;
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.checkClosed();
            this.delegator.commit();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.createArrayOf(typeName, elements);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.createBlob();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.createClob();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.createNClob();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.createSQLXML();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            this.checkClosed();
            return new PGStatementDelegator(this, this.delegator.createStatement());
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkClosed();
            return new PGStatementDelegator(this, this.delegator.createStatement(resultSetType, resultSetConcurrency));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkClosed();
            return new PGStatementDelegator(this, this.delegator.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.createStruct(typeName, attributes);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getAutoCommit();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getCatalog();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getClientInfo();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getClientInfo(name);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getHoldability();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getMetaData();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getNetworkTimeout();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getSchema();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getTransactionIsolation();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getTypeMap();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.getWarnings();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegator == null ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.isReadOnly();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.isValid(timeout);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.nativeSQL(sql);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            this.checkClosed();
            return new PGCallableStatementDelegator(this, this.delegator.prepareCall(sql));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkClosed();
            return new PGCallableStatementDelegator(this, this.delegator.prepareCall(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkClosed();
            return new PGCallableStatementDelegator(this, this.delegator.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            this.checkClosed();
            return new PGPreparedStatementDelegator(this, this.delegator.prepareStatement(sql));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.checkClosed();
            return new PGPreparedStatementDelegator(this, this.delegator.prepareStatement(sql, autoGeneratedKeys));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.checkClosed();
            return new PGPreparedStatementDelegator(this, this.delegator.prepareStatement(sql, columnIndexes));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.checkClosed();
            return new PGPreparedStatementDelegator(this, this.delegator.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.checkClosed();
            return new PGPreparedStatementDelegator(this, this.delegator.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            this.checkClosed();
            return new PGPreparedStatementDelegator(this, this.delegator.prepareStatement(sql, columnNames));
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.releaseSavepoint(savepoint);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.checkClosed();
            this.delegator.rollback();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.rollback(savepoint);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.setAutoCommit(autoCommit);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.setCatalog(catalog);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkClosed();
            this.delegator.setClientInfo(properties);
        }
        catch (SQLClientInfoException scie) {
            this.owner.fireConnectionError(scie);
            throw scie;
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            SQLClientInfoException scie = new SQLClientInfoException();
            scie.initCause(se);
            throw scie;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkClosed();
            this.delegator.setClientInfo(name, value);
        }
        catch (SQLClientInfoException scie) {
            this.owner.fireConnectionError(scie);
            throw scie;
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            SQLClientInfoException scie = new SQLClientInfoException();
            scie.initCause(se);
            throw scie;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            this.delegator.setHoldability(holdability);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.setReadOnly(readOnly);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.setSavepoint();
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.setSavepoint(name);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.setSchema(schema);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.setTransactionIsolation(level);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.checkClosed();
            this.delegator.setTypeMap(map);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.isWrapperFor(iface);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            this.checkClosed();
            return this.delegator.unwrap(iface);
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    @Override
    public void setStrictMode(boolean v) {
        this.delegator.setStrictMode(v);
    }

    @Override
    public boolean isStrictMode() {
        return this.delegator.isStrictMode();
    }

    void reset() {
        if (this.delegator != null) {
            this.automatic = true;
        }
        this.delegator = null;
    }

    void fireConnectionError(SQLException se) {
        this.owner.fireConnectionError(se);
    }

    void fireStatementClosed(PreparedStatement ps) {
        this.owner.fireStatementClosed(ps);
    }

    void fireStatementError(PreparedStatement ps, SQLException se) {
        this.owner.fireStatementError(ps, se);
    }

    private void checkClosed() throws SQLException {
        if (this.delegator == null) {
            throw new PGSQLSimpleException(this.automatic ? "Connection has been closed automatically" : "Connection has been closed", "08003");
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PGPooledConnectionDelegator)) {
            return false;
        }
        PGPooledConnectionDelegator other = (PGPooledConnectionDelegator)o;
        return this.delegator.equals(other.delegator);
    }
}

