/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.datetime.instants.Instants;
import com.impossibl.postgres.jdbc.CachedStatement;
import com.impossibl.postgres.jdbc.CachedStatementKey;
import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGParameterMetaData;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.jdbc.PGResultSetMetaData;
import com.impossibl.postgres.jdbc.PGSQLXML;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.SQLTypeMetaData;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.jdbc.Unwrapping;
import com.impossibl.postgres.protocol.BindExecCommand;
import com.impossibl.postgres.protocol.PrepareCommand;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.ByteStreams;
import com.impossibl.postgres.utils.guava.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class PGPreparedStatement
extends PGStatement
implements PreparedStatement {
    String sqlText;
    List<Type> parameterTypes;
    List<Object> parameterValues;
    int parameterCount;
    List<Boolean> parameterSet;
    List<List<Type>> batchParameterTypes;
    List<List<Object>> batchParameterValues;
    boolean wantsGeneratedKeys;
    boolean parsed;

    PGPreparedStatement(PGConnectionImpl connection, int type, int concurrency, int holdability, String name, String sqlText, int parameterCount, String cursorName) {
        super(connection, type, concurrency, holdability, null, null);
        this.sqlText = sqlText;
        this.parameterTypes = new ArrayList<Type>(Arrays.asList(new Type[parameterCount]));
        this.parameterValues = new ArrayList<Object>(Arrays.asList(new Object[parameterCount]));
        this.parameterCount = parameterCount;
        this.parameterSet = new ArrayList<Boolean>(Arrays.asList(new Boolean[parameterCount]));
        this.cursorName = cursorName;
    }

    public boolean getWantsGeneratedKeys() {
        return this.wantsGeneratedKeys;
    }

    public void setWantsGeneratedKeys(boolean wantsGeneratedKeys) {
        this.wantsGeneratedKeys = wantsGeneratedKeys;
    }

    void set(int parameterIdx, Object val, int targetSQLType) throws SQLException {
        this.checkClosed();
        if (parameterIdx < 1 || parameterIdx > this.parameterValues.size()) {
            throw Exceptions.PARAMETER_INDEX_OUT_OF_BOUNDS;
        }
        Type paramType = this.parameterTypes.get(--parameterIdx);
        if (targetSQLType == 2003 || targetSQLType == 2002 || targetSQLType == 1111) {
            targetSQLType = 0;
        }
        if (paramType == null || targetSQLType != SQLTypeMetaData.getSQLType(paramType)) {
            paramType = SQLTypeMetaData.getType(targetSQLType, this.connection.getRegistry());
            this.parameterTypes.set(parameterIdx, paramType);
            this.parsed = false;
        }
        this.parameterValues.set(parameterIdx, val);
        if (this.parameterCount > 0) {
            this.parameterSet.set(parameterIdx, Boolean.TRUE);
        }
    }

    @Override
    void internalClose() throws SQLException {
        super.internalClose();
        this.parameterTypes = null;
        this.parameterValues = null;
        this.parameterSet = null;
    }

    void verifyParameterSet() throws SQLException {
        if (this.parameterCount > 0) {
            int count = 0;
            for (Boolean b : this.parameterSet) {
                if (b == null || !Boolean.TRUE.equals(b)) continue;
                ++count;
            }
            if (count != this.parameterCount) {
                throw new SQLException("Incorrect parameter count, was " + count + ", expected: " + this.parameterCount);
            }
        }
    }

    void parseIfNeeded() throws SQLException {
        if (this.cursorName != null && this.command != null) {
            super.executeSimple("CLOSE " + this.cursorName);
        }
        if (!this.parsed) {
            CachedStatement cachedStatement;
            if (this.name != null && !this.name.startsWith("cached-")) {
                this.connection.execute(this.connection.getProtocol().createClose(ServerObjectType.Statement, this.name), false);
            }
            try {
                final CachedStatementKey key = new CachedStatementKey(this.sqlText, Collections.emptyList());
                cachedStatement = this.connection.getCachedStatement(key, new Callable<CachedStatement>(){

                    @Override
                    public CachedStatement call() throws Exception {
                        String name = PGPreparedStatement.this.connection.isCacheEnabled() ? "cached-" + Integer.toString(key.hashCode()) : "nocache-" + Integer.toString(key.hashCode());
                        PrepareCommand prep = PGPreparedStatement.this.connection.getProtocol().createPrepare(name, PGPreparedStatement.this.sqlText, Collections.emptyList());
                        PGPreparedStatement.this.warningChain = PGPreparedStatement.this.connection.execute(prep, true);
                        return new CachedStatement(name, prep.getDescribedParameterTypes(), prep.getDescribedResultFields());
                    }
                });
            }
            catch (ExecutionException e) {
                throw (SQLException)e.getCause();
            }
            catch (Exception e) {
                throw (SQLException)e;
            }
            this.name = cachedStatement.name;
            this.parameterTypes = this.copyNonNullTypes(this.parameterTypes, cachedStatement.parameterTypes);
            this.resultFields = cachedStatement.resultFields;
            this.parsed = true;
        }
    }

    boolean allowBatchSelects() {
        return false;
    }

    private void coerceParameters() throws SQLException {
        int sz = this.parameterTypes.size();
        for (int c = 0; c < sz; ++c) {
            Type parameterType = this.parameterTypes.get(c);
            Object parameterValue = this.parameterValues.get(c);
            if (parameterType != null && parameterValue != null) {
                Class<?> targetType = SQLTypeUtils.mapSetType(parameterType);
                try {
                    parameterValue = SQLTypeUtils.coerce(parameterValue, parameterType, targetType, Collections.emptyMap(), TimeZone.getDefault(), this.connection);
                }
                catch (SQLException coercionException) {
                    throw new SQLException("Error converting parameter " + c, coercionException);
                }
            }
            this.parameterValues.set(c, parameterValue);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        this.parseIfNeeded();
        this.closeResultSets();
        this.verifyParameterSet();
        this.coerceParameters();
        boolean res = super.executeStatement(this.name, this.parameterTypes, this.parameterValues);
        if (this.cursorName != null) {
            res = super.executeSimple("FETCH ABSOLUTE 0 FROM " + this.cursorName);
        }
        if (this.wantsGeneratedKeys) {
            this.generatedKeysResultSet = this.getResultSet();
        }
        return res;
    }

    @Override
    public PGResultSet executeQuery() throws SQLException {
        this.execute();
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchParameterTypes == null) {
            this.batchParameterTypes = new ArrayList<List<Type>>();
        }
        if (this.batchParameterValues == null) {
            this.batchParameterValues = new ArrayList<List<Object>>();
        }
        this.coerceParameters();
        this.batchParameterTypes.add(new ArrayList<Type>(this.parameterTypes));
        this.batchParameterValues.add(new ArrayList<Object>(this.parameterValues));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.batchParameterValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        this.closeResultSets();
        try {
            int c;
            this.warningChain = null;
            if (this.batchParameterValues == null || this.batchParameterValues.isEmpty()) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int[] counts = new int[this.batchParameterValues.size()];
            Arrays.fill(counts, -2);
            ArrayList<Object[]> generatedKeys = new ArrayList<Object[]>();
            BindExecCommand command = this.connection.getProtocol().createBindExec(null, null, this.parameterTypes, Collections.emptyList(), this.resultFields, Object[].class);
            List<Type> lastParameterTypes = null;
            List<ResultField> lastResultFields = null;
            int sz = this.batchParameterValues.size();
            try {
                for (c = 0; c < sz; ++c) {
                    List<Type> parameterTypes = this.mergeTypes(this.batchParameterTypes.get(c), lastParameterTypes);
                    if (lastParameterTypes == null || !lastParameterTypes.equals(parameterTypes)) {
                        PrepareCommand prep = this.connection.getProtocol().createPrepare(null, this.sqlText, parameterTypes);
                        this.connection.execute(prep, true);
                        lastParameterTypes = parameterTypes = prep.getDescribedParameterTypes();
                        lastResultFields = prep.getDescribedResultFields();
                    }
                    List<Object> parameterValues = this.batchParameterValues.get(c);
                    command.setParameterTypes(parameterTypes);
                    command.setParameterValues(parameterValues);
                    SQLWarning warnings = this.connection.execute(command, true);
                    this.warningChain = ErrorUtils.chainWarnings(this.warningChain, warnings);
                    List<QueryCommand.ResultBatch> resultBatches = command.getResultBatches();
                    if (resultBatches.size() != 1) {
                        throw new BatchUpdateException(counts);
                    }
                    QueryCommand.ResultBatch resultBatch = resultBatches.get(0);
                    if (!this.allowBatchSelects() && resultBatch.command.equals("SELECT")) {
                        throw new SQLException("SELECT in executeBatch");
                    }
                    counts[c] = resultBatch.rowsAffected == null ? 0 : (int)resultBatch.rowsAffected.longValue();
                    if (!this.wantsGeneratedKeys) continue;
                    generatedKeys.add((Object[])resultBatch.results.get(0));
                }
            }
            catch (SQLException se) {
                int[] updateCounts = new int[c + 1];
                for (int i = 0; i < updateCounts.length - 1; ++i) {
                    updateCounts[i] = counts[i];
                }
                updateCounts[c] = -3;
                throw new BatchUpdateException(updateCounts, (Throwable)se);
            }
            this.generatedKeysResultSet = this.createResultSet(lastResultFields, generatedKeys);
            int[] nArray = counts;
            return nArray;
        }
        finally {
            this.batchParameterTypes = null;
            this.batchParameterValues = null;
        }
    }

    List<Type> mergeTypes(List<Type> list, List<Type> defaultTypes) {
        if (defaultTypes == null) {
            return list;
        }
        int sz = list.size();
        for (int c = 0; c < sz; ++c) {
            Type type = list.get(c);
            if (type == null) {
                type = defaultTypes.get(c);
            }
            list.set(c, type);
        }
        return list;
    }

    List<Type> copyNonNullTypes(List<Type> list, List<Type> sourceTypes) {
        if (sourceTypes == null) {
            return list;
        }
        int sz = list.size();
        for (int c = 0; c < sz; ++c) {
            Type type = sourceTypes.get(c);
            if (type == null) continue;
            list.set(c, type);
        }
        return list;
    }

    @Override
    public void clearParameters() throws SQLException {
        int c;
        this.checkClosed();
        for (c = 0; c < this.parameterValues.size(); ++c) {
            this.parameterValues.set(c, null);
        }
        for (c = 0; c < this.parameterSet.size(); ++c) {
            this.parameterSet.set(c, Boolean.FALSE);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        this.parseIfNeeded();
        return new PGParameterMetaData(this.parameterTypes, this.connection.getTypeMap());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        this.parseIfNeeded();
        return new PGResultSetMetaData(this.connection, this.resultFields, this.connection.getTypeMap());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.set(parameterIndex, null, 0);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.set(parameterIndex, x, 16);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.set(parameterIndex, x, -6);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.set(parameterIndex, x, 5);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.set(parameterIndex, x, 4);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.set(parameterIndex, x, -5);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.set(parameterIndex, Float.valueOf(x), 6);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.set(parameterIndex, x, 8);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.set(parameterIndex, x, 3);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.set(parameterIndex, x, 12);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.set(parameterIndex, x, -2);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, Calendar.getInstance());
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, Calendar.getInstance());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, Calendar.getInstance());
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        TimeZone zone = cal.getTimeZone();
        this.set(parameterIndex, Instants.fromDate(x, zone), 91);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        TimeZone zone = cal.getTimeZone();
        this.set(parameterIndex, Instants.fromTime(x, zone), 92);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkClosed();
        TimeZone zone = cal.getTimeZone();
        this.set(parameterIndex, Instants.fromTimestamp(x, zone), 93);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.set(parameterIndex, x, -2);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (length < 0) {
            throw new SQLException("Invalid length");
        }
        if (x != null) {
            x = ByteStreams.limit(x, length);
        } else if (length != 0) {
            throw new SQLException("Invalid length");
        }
        this.set(parameterIndex, x, -2);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLException("Invalid length");
        }
        if (x != null) {
            x = ByteStreams.limit(x, length);
        } else if (length != 0L) {
            throw new SQLException("Invalid length");
        }
        this.set(parameterIndex, x, -2);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        InputStreamReader reader = new InputStreamReader(x, StandardCharsets.UTF_8);
        this.setCharacterStream(parameterIndex, (Reader)reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1L);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        InputStreamReader reader = new InputStreamReader(x, StandardCharsets.US_ASCII);
        this.setCharacterStream(parameterIndex, (Reader)reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, -1L);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        StringWriter writer = new StringWriter();
        try {
            CharStreams.copy(reader, writer);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.set(parameterIndex, writer.toString(), 12);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof URL) {
            this.setURL(parameterIndex, (URL)x);
        } else if (x instanceof SQLXML) {
            this.setSQLXML(parameterIndex, (SQLXML)x);
        } else if (x instanceof RowId) {
            this.setRowId(parameterIndex, (RowId)x);
        } else if (x instanceof Ref) {
            this.setRef(parameterIndex, (Ref)x);
        } else if (x instanceof NClob) {
            this.setNClob(parameterIndex, (NClob)x);
        } else {
            this.set(parameterIndex, x, 1111);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkClosed();
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapObject(this.connection, x), targetSqlType);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapBlob(this.connection, x), 2004);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBlob(parameterIndex, ByteStreams.limit(inputStream, length));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        Blob blob = this.connection.createBlob();
        try {
            ByteStreams.copy(inputStream, blob.setBinaryStream(1L));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.set(parameterIndex, blob, 2004);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapClob(this.connection, x), 2005);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, CharStreams.limit(reader, length));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        Clob clob = this.connection.createClob();
        try {
            CharStreams.copy(reader, clob.setCharacterStream(1L));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.set(parameterIndex, clob, 2005);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.set(parameterIndex, x, 2003);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.set(parameterIndex, null, 0);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.set(parameterIndex, x, 12);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkClosed();
        if (!(xmlObject instanceof PGSQLXML)) {
            throw new SQLException("SQLXML object not created by driver");
        }
        PGSQLXML sqlXml = (PGSQLXML)xmlObject;
        this.set(parameterIndex, sqlXml.getData(), 2009);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkClosed();
        this.set(parameterIndex, Unwrapping.unwrapRowId(this.connection, x), -8);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Exceptions.NOT_ALLOWED_ON_PREP_STMT;
    }
}

