/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.api.jdbc.PGSQLInput;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGArray;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.utils.guava.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TimeZone;

public class PGSQLInputImpl
implements PGSQLInput {
    private PGConnectionImpl connection;
    private CompositeType type;
    private Map<String, Class<?>> typeMap;
    private int currentAttrIdx;
    private Object[] attributeValues;
    private Boolean nullFlag;

    public PGSQLInputImpl(PGConnectionImpl connection, CompositeType type, Map<String, Class<?>> typeMap, Object[] attributeValues) {
        this.connection = connection;
        this.type = type;
        this.typeMap = typeMap;
        this.attributeValues = attributeValues;
    }

    public Object[] getAttributeValues() {
        return this.attributeValues;
    }

    private Object getNextAttributeValue() {
        Object val;
        this.nullFlag = (val = this.attributeValues[this.currentAttrIdx++]) == null;
        return val;
    }

    @Override
    public String readString() throws SQLException {
        return SQLTypeUtils.coerceToString(this.getNextAttributeValue(), this.type, this.connection);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        return SQLTypeUtils.coerceToBoolean(this.getNextAttributeValue());
    }

    @Override
    public byte readByte() throws SQLException {
        return SQLTypeUtils.coerceToByte(this.getNextAttributeValue());
    }

    @Override
    public short readShort() throws SQLException {
        return SQLTypeUtils.coerceToShort(this.getNextAttributeValue());
    }

    @Override
    public int readInt() throws SQLException {
        return SQLTypeUtils.coerceToInt(this.getNextAttributeValue());
    }

    @Override
    public long readLong() throws SQLException {
        return SQLTypeUtils.coerceToLong(this.getNextAttributeValue());
    }

    @Override
    public float readFloat() throws SQLException {
        return SQLTypeUtils.coerceToFloat(this.getNextAttributeValue());
    }

    @Override
    public double readDouble() throws SQLException {
        return SQLTypeUtils.coerceToDouble(this.getNextAttributeValue());
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return SQLTypeUtils.coerceToBigDecimal(this.getNextAttributeValue());
    }

    @Override
    public byte[] readBytes() throws SQLException {
        Object val = this.getNextAttributeValue();
        if (val == null) {
            return null;
        }
        CompositeType.Attribute attr = this.type.getAttribute(this.currentAttrIdx);
        if (attr == null) {
            throw new SQLException("Invalid input request (type not array)");
        }
        InputStream data = SQLTypeUtils.coerceToByteStream(val, attr.type, this.connection);
        try {
            return ByteStreams.toByteArray(data);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Date readDate() throws SQLException {
        return SQLTypeUtils.coerceToDate(this.getNextAttributeValue(), TimeZone.getDefault(), this.connection);
    }

    @Override
    public Time readTime() throws SQLException {
        return SQLTypeUtils.coerceToTime(this.getNextAttributeValue(), TimeZone.getDefault(), this.connection);
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return SQLTypeUtils.coerceToTimestamp(this.getNextAttributeValue(), TimeZone.getDefault(), this.connection);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        return new StringReader(SQLTypeUtils.coerceToString(this.getNextAttributeValue(), this.type, this.connection));
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        return new ByteArrayInputStream(SQLTypeUtils.coerceToString(this.getNextAttributeValue(), this.type, this.connection).getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public Object readObject() throws SQLException {
        Object val = this.getNextAttributeValue();
        if (val == null) {
            return null;
        }
        CompositeType.Attribute attr = this.type.getAttribute(this.currentAttrIdx);
        if (attr == null) {
            throw new SQLException("Invalid input request (type not array)");
        }
        Class<?> targetType = SQLTypeUtils.mapGetType(attr.type, this.typeMap, this.connection);
        return SQLTypeUtils.coerce(val, attr.type, targetType, this.typeMap, this.connection);
    }

    @Override
    public Ref readRef() throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public Blob readBlob() throws SQLException {
        return SQLTypeUtils.coerceToBlob(this.getNextAttributeValue(), this.connection);
    }

    @Override
    public Clob readClob() throws SQLException {
        return SQLTypeUtils.coerceToClob(this.getNextAttributeValue(), this.connection);
    }

    @Override
    public Array readArray() throws SQLException {
        Object val = this.getNextAttributeValue();
        if (val == null) {
            return null;
        }
        CompositeType.Attribute attr = this.type.getAttribute(this.currentAttrIdx);
        if (attr == null || !(attr.type instanceof ArrayType) || !(val instanceof Object[])) {
            throw new SQLException("Invalid input request (type not array)");
        }
        return new PGArray(this.connection, (ArrayType)attr.type, (Object[])val);
    }

    @Override
    public URL readURL() throws SQLException {
        return SQLTypeUtils.coerceToURL(this.getNextAttributeValue());
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        return SQLTypeUtils.coerceToXML(this.getNextAttributeValue(), this.connection);
    }

    @Override
    public RowId readRowId() throws SQLException {
        return SQLTypeUtils.coerceToRowId(this.getNextAttributeValue(), this.type.getAttribute((int)this.currentAttrIdx).type);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.nullFlag == null) {
            throw new SQLException("no value read");
        }
        return this.nullFlag;
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public String readNString() throws SQLException {
        throw Exceptions.NOT_SUPPORTED;
    }
}

