/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.SQLText;
import com.impossibl.postgres.jdbc.SQLTextEscapes;
import com.impossibl.postgres.jdbc.SQLTextUtils;
import com.impossibl.postgres.protocol.PrepareCommand;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ServerObjectType;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Collections;

class PGSimpleStatement
extends PGStatement {
    SQLText batchCommands;

    public PGSimpleStatement(PGConnectionImpl connection, int type, int concurrency, int holdability) {
        super(connection, type, concurrency, holdability, null, null);
    }

    SQLWarning prepare(SQLText sqlText) throws SQLException {
        if (this.resultSetConcurrency != 1007) {
            this.name = this.connection.getNextStatementName();
            this.cursorName = "cursor" + this.name;
            if (!SQLTextUtils.prependCursorDeclaration(sqlText, this.cursorName, this.resultSetType, this.resultSetHoldability, this.connection.autoCommit)) {
                this.name = null;
                this.cursorName = null;
            }
        }
        PrepareCommand prep = this.connection.getProtocol().createPrepare(this.name, sqlText.toString(), Collections.emptyList());
        SQLWarning warningChain = this.connection.execute(prep, true);
        this.resultFields = prep.getDescribedResultFields();
        return warningChain;
    }

    boolean execute(SQLText sqlText) throws SQLException {
        if (this.name != null) {
            PGSimpleStatement.dispose(this.connection, ServerObjectType.Statement, this.name);
        }
        if (this.processEscapes) {
            SQLTextEscapes.processEscapes(sqlText, this.connection);
        }
        if (sqlText.getStatementCount() > 1) {
            return this.executeSimple(sqlText.toString());
        }
        SQLWarning prepWarningChain = this.prepare(sqlText);
        boolean res = this.executeStatement(this.name, Collections.emptyList(), Collections.emptyList());
        if (this.cursorName != null) {
            res = super.executeSimple("FETCH ABSOLUTE 0 FROM " + this.cursorName);
        }
        this.warningChain = ErrorUtils.chainWarnings(prepWarningChain, this.warningChain);
        return res;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.connection.parseSQL(sql);
        return this.execute(sqlText);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.connection.parseSQL(sql);
        if (autoGeneratedKeys != 1) {
            return this.execute(sqlText);
        }
        if (!SQLTextUtils.appendReturningClause(sqlText)) {
            throw Exceptions.INVALID_COMMAND_FOR_GENERATED_KEYS;
        }
        this.execute(sqlText);
        this.generatedKeysResultSet = this.getResultSet();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.connection.parseSQL(sql);
        if (!SQLTextUtils.appendReturningClause(sqlText, Arrays.asList(columnNames))) {
            throw Exceptions.INVALID_COMMAND_FOR_GENERATED_KEYS;
        }
        this.execute(sqlText);
        this.generatedKeysResultSet = this.getResultSet();
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw Exceptions.NO_RESULT_SET_AVAILABLE;
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        if (this.execute(sql)) {
            throw Exceptions.NO_RESULT_COUNT_AVAILABLE;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.execute(sql, autoGeneratedKeys)) {
            throw Exceptions.NO_RESULT_COUNT_AVAILABLE;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.execute(sql, columnIndexes)) {
            throw Exceptions.NO_RESULT_COUNT_AVAILABLE;
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.execute(sql, columnNames)) {
            throw Exceptions.NO_RESULT_COUNT_AVAILABLE;
        }
        return this.getUpdateCount();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.connection.parseSQL(sql);
        if (this.batchCommands == null) {
            this.batchCommands = sqlText;
        } else {
            this.batchCommands.addStatements(sqlText);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchCommands = null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        int[] counts = new int[]{};
        int c = 0;
        try {
            Object resultBatch;
            this.warningChain = null;
            if (this.batchCommands == null) {
                int[] nArray = new int[]{};
                return nArray;
            }
            this.execute(this.batchCommands);
            counts = new int[this.resultBatches.size()];
            for (c = 0; c < this.resultBatches.size(); ++c) {
                resultBatch = (QueryCommand.ResultBatch)this.resultBatches.get(c);
                if (resultBatch.command.equals("SELECT")) {
                    throw new BatchUpdateException("SELECT in executeBatch", Arrays.copyOf(counts, c));
                }
                counts[c] = resultBatch.rowsAffected != null ? (int)((QueryCommand.ResultBatch)this.resultBatches.get((int)c)).rowsAffected.longValue() : -2;
            }
            resultBatch = counts;
            return resultBatch;
        }
        catch (BatchUpdateException bue) {
            throw bue;
        }
        catch (SQLException se) {
            throw new BatchUpdateException(Arrays.copyOf(counts, c), (Throwable)se);
        }
        finally {
            this.batchCommands = null;
            this.command = null;
            this.resultBatches = null;
        }
    }
}

