/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.types.CompositeType;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PGStruct
implements Struct {
    PGConnectionImpl connection;
    CompositeType type;
    Object[] values;

    public PGStruct(PGConnectionImpl connection, CompositeType type, Object[] values) {
        this.connection = connection;
        this.type = type;
        this.values = values;
    }

    public CompositeType getType() {
        return this.type;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.type.getName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.getAttributes(this.connection.getTypeMap());
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        Object[] newValues = new Object[this.values.length];
        List<CompositeType.Attribute> attrs = this.type.getAttributes();
        for (int c = 0; c < attrs.size(); ++c) {
            CompositeType.Attribute attr = attrs.get(c);
            Class<?> targetType = SQLTypeUtils.mapGetType(attr.type, map, this.connection);
            newValues[c] = SQLTypeUtils.coerce(this.values[c], attr.type, targetType, map, this.connection);
        }
        return newValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PGStruct other = (PGStruct)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }
}

