/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc.xa;

import com.impossibl.postgres.jdbc.xa.Base64;
import java.util.Arrays;
import javax.transaction.xa.Xid;

class RecoveredXid
implements Xid {
    private int formatId;
    private byte[] globalTransactionId;
    private byte[] branchQualifier;

    RecoveredXid() {
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)o;
        if (other.getFormatId() != this.formatId) {
            return false;
        }
        if (!Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId())) {
            return false;
        }
        return Arrays.equals(this.branchQualifier, other.getBranchQualifier());
    }

    public int hashCode() {
        int hashCode = 37;
        hashCode += 7 * this.formatId;
        hashCode += 7 * Arrays.hashCode(this.globalTransactionId);
        return hashCode += 7 * Arrays.hashCode(this.branchQualifier);
    }

    public String toString() {
        return RecoveredXid.xidToString(this);
    }

    static String xidToString(Xid xid) {
        return xid.getFormatId() + "_" + Base64.encodeBytes(xid.getGlobalTransactionId(), 8) + "_" + Base64.encodeBytes(xid.getBranchQualifier(), 8);
    }

    static Xid stringToXid(String s) {
        int b;
        RecoveredXid xid = new RecoveredXid();
        int a = s.indexOf(95);
        if (a == (b = s.lastIndexOf(95))) {
            return null;
        }
        try {
            xid.formatId = Integer.parseInt(s.substring(0, a));
            xid.globalTransactionId = Base64.decode(s.substring(a + 1, b));
            xid.branchQualifier = Base64.decode(s.substring(b + 1));
            if (xid.globalTransactionId == null || xid.branchQualifier == null) {
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return xid;
    }
}

