/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.mapper;

import com.impossibl.postgres.mapper.ArrayPropertySetter;
import com.impossibl.postgres.mapper.FieldPropertySetter;
import com.impossibl.postgres.mapper.ListPropertySetter;
import com.impossibl.postgres.mapper.MapPropertySetter;
import com.impossibl.postgres.mapper.MethodPropertySetter;
import com.impossibl.postgres.mapper.PropertySetter;
import com.impossibl.postgres.protocol.ResultField;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Mapper {
    public static List<PropertySetter> buildMapping(Class<?> rowType, List<ResultField> fields) {
        PropertySetter[] setters = rowType.isArray() && rowType.getComponentType() == Object.class ? Mapper.initArraySetters(fields) : (List.class.isAssignableFrom(rowType) ? Mapper.initListSetters(fields) : (Map.class.isAssignableFrom(rowType) ? Mapper.initMapSetters(fields) : Mapper.initBeanSetters(rowType, fields)));
        return Arrays.asList(setters);
    }

    protected static PropertySetter[] initArraySetters(List<ResultField> fields) {
        PropertySetter[] setters = new PropertySetter[fields.size()];
        for (int c = 0; c < setters.length; ++c) {
            setters[c] = new ArrayPropertySetter(c);
        }
        return setters;
    }

    protected static PropertySetter[] initListSetters(List<ResultField> fields) {
        PropertySetter[] setters = new PropertySetter[fields.size()];
        for (int c = 0; c < setters.length; ++c) {
            setters[c] = new ListPropertySetter(c);
        }
        return setters;
    }

    protected static PropertySetter[] initMapSetters(List<ResultField> fields) {
        PropertySetter[] setters = new PropertySetter[fields.size()];
        for (int c = 0; c < setters.length; ++c) {
            setters[c] = new MapPropertySetter(fields.get((int)c).name);
        }
        return setters;
    }

    protected static PropertySetter[] initBeanSetters(Class<?> instanceType, List<ResultField> fields) {
        PropertyDescriptor[] propDescs;
        PropertySetter[] setters = new PropertySetter[fields.size()];
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(instanceType);
            propDescs = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            propDescs = new PropertyDescriptor[]{};
        }
        for (int c = 0; c < setters.length; ++c) {
            Field field;
            PropertyDescriptor propDesc = Mapper.findPropertyDescriptor(propDescs, fields.get((int)c).name);
            setters[c] = propDesc != null ? new MethodPropertySetter(propDesc.getWriteMethod()) : ((field = Mapper.findField(instanceType, fields.get((int)c).name)) != null ? new FieldPropertySetter(field) : null);
        }
        return setters;
    }

    private static Field findField(Class<?> instanceType, String name) {
        try {
            return instanceType.getField(name);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            return null;
        }
    }

    private static PropertyDescriptor findPropertyDescriptor(PropertyDescriptor[] propDescs, String name) {
        for (PropertyDescriptor propDesc : propDescs) {
            if (!propDesc.getName().equals(name)) continue;
            return propDesc;
        }
        return null;
    }
}

