/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Command;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.protocol.v30.ProtocolListener;
import com.impossibl.postgres.utils.BlockingReadTimeoutException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CommandImpl
implements Command {
    protected long networkTimeout;
    protected Throwable exception;
    protected Notice error;
    protected List<Notice> notices;

    @Override
    public long getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Override
    public void setNetworkTimeout(long timeout) {
        this.networkTimeout = timeout;
    }

    @Override
    public Notice getError() {
        return this.error;
    }

    public void setError(Notice error) {
        this.error = error;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable cause) {
        this.exception = cause;
    }

    public void addNotice(Notice notice) {
        if (this.notices == null) {
            this.notices = new ArrayList<Notice>();
        }
        this.notices.add(notice);
    }

    @Override
    public List<Notice> getWarnings() {
        if (this.notices == null) {
            return Collections.emptyList();
        }
        ArrayList<Notice> warnings = new ArrayList<Notice>();
        for (Notice notice : this.notices) {
            if (!notice.isWarning()) continue;
            warnings.add(notice);
        }
        return warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(ProtocolListener listener) throws IOException {
        long networkTimeout = this.networkTimeout;
        if (networkTimeout < 1L) {
            networkTimeout = Long.MAX_VALUE;
        }
        ProtocolListener protocolListener = listener;
        synchronized (protocolListener) {
            while (!listener.isComplete() && !listener.isAborted() && networkTimeout > 0L) {
                long start = System.currentTimeMillis();
                try {
                    listener.wait(networkTimeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if ((networkTimeout -= System.currentTimeMillis() - start) >= 1L) continue;
                throw new BlockingReadTimeoutException("network timeout reached");
            }
        }
    }

    public void enableCancelTimer(ProtocolImpl protocol, long timeout) {
        if (timeout < 1L) {
            return;
        }
        protocol.enableExecutionTimer(new CancelExecutionTimerTask(protocol), timeout);
    }

    public abstract void execute(ProtocolImpl var1) throws IOException;

    static class CancelExecutionTimerTask
    extends ProtocolImpl.ExecutionTimerTask {
        ProtocolImpl protocol;

        public CancelExecutionTimerTask(ProtocolImpl protocol) {
            this.protocol = protocol;
        }

        @Override
        public void run() {
            this.protocol.sendCancelRequest();
        }
    }
}

