/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.PrepareCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.protocol.v30.BaseProtocolListener;
import com.impossibl.postgres.protocol.v30.CommandImpl;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.protocol.v30.ProtocolListener;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PrepareCommandImpl
extends CommandImpl
implements PrepareCommand {
    private String statementName;
    private String query;
    private List<Type> parseParameterTypes;
    private List<TypeRef> describedParameterTypes;
    private List<ResultField> describedResultFields;
    private ProtocolListener listener = new BaseProtocolListener(){

        @Override
        public void parseComplete() {
        }

        @Override
        public boolean isComplete() {
            return PrepareCommandImpl.this.describedResultFields != null || PrepareCommandImpl.this.error != null || PrepareCommandImpl.this.exception != null;
        }

        @Override
        public void parametersDescription(List<TypeRef> parameterTypes) {
            PrepareCommandImpl.this.describedParameterTypes = parameterTypes;
        }

        @Override
        public void rowDescription(List<ResultField> resultFields) {
            for (ResultField field : resultFields) {
                field.format = ResultField.Format.Binary;
            }
            PrepareCommandImpl.this.describedResultFields = resultFields;
        }

        @Override
        public void noData() {
            PrepareCommandImpl.this.describedResultFields = Collections.emptyList();
        }

        @Override
        public synchronized void error(Notice error) {
            PrepareCommandImpl.this.error = error;
            this.notifyAll();
        }

        @Override
        public synchronized void exception(Throwable cause) {
            PrepareCommandImpl.this.setException(cause);
            this.notifyAll();
        }

        @Override
        public synchronized void ready(TransactionStatus txStatus) {
            this.notifyAll();
        }

        @Override
        public void notice(Notice notice) {
            PrepareCommandImpl.this.addNotice(notice);
        }
    };

    public PrepareCommandImpl(String statementName, String query, List<Type> parseParameterTypes) {
        this.statementName = statementName;
        this.query = query;
        this.parseParameterTypes = parseParameterTypes;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public String getStatementName() {
        return this.statementName;
    }

    @Override
    public List<Type> getParseParameterTypes() {
        return this.parseParameterTypes;
    }

    @Override
    public List<Type> getDescribedParameterTypes() {
        ArrayList<Type> types = new ArrayList<Type>();
        for (TypeRef typeRef : this.describedParameterTypes) {
            types.add(typeRef.get());
        }
        return types;
    }

    @Override
    public List<ResultField> getDescribedResultFields() {
        return this.describedResultFields;
    }

    @Override
    public void execute(ProtocolImpl protocol) throws IOException {
        protocol.setListener(this.listener);
        ByteBuf msg = protocol.channel.alloc().buffer();
        protocol.writeParse(msg, this.statementName, this.query, this.parseParameterTypes);
        protocol.writeDescribe(msg, ServerObjectType.Statement, this.statementName);
        protocol.writeSync(msg);
        protocol.send(msg);
        this.waitFor(this.listener);
    }
}

