/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.v30.MessageDecoder;
import com.impossibl.postgres.protocol.v30.MessageHandler;
import com.impossibl.postgres.protocol.v30.NamedThreadFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ProtocolShared {
    static ProtocolShared instance;
    private Bootstrap bootstrap;
    private int count = 0;

    public static synchronized Ref acquire() {
        if (instance == null) {
            instance = new ProtocolShared();
        }
        return instance.addReference();
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    private synchronized Ref addReference() {
        if (this.count == 0) {
            this.init();
        }
        ++this.count;
        return new Ref();
    }

    private synchronized void release() {
        if (this.count == 1) {
            this.shutdown();
            this.count = 0;
        } else {
            --this.count;
        }
    }

    private void init() {
        int workerCount = Runtime.getRuntime().availableProcessors();
        NioEventLoopGroup group = new NioEventLoopGroup(workerCount, (ThreadFactory)new NamedThreadFactory("PG-JDBC EventLoop"));
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new MessageDecoder(), new MessageHandler()});
            }
        })).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
    }

    public Future<?> shutdown() {
        return this.bootstrap.group().shutdownGracefully(10L, 100L, TimeUnit.MILLISECONDS);
    }

    public void waitForShutdown() {
        this.shutdown().awaitUninterruptibly();
        try {
            ThreadDeathWatcher.awaitInactivity((long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public class Ref {
        private boolean released;

        public ProtocolShared get() {
            return ProtocolShared.this;
        }

        public void release() {
            if (!this.released) {
                this.released = true;
                ProtocolShared.this.release();
            }
        }
    }
}

