/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BaseProtocolListener;
import com.impossibl.postgres.protocol.v30.CommandImpl;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class QueryCommandImpl
extends CommandImpl
implements QueryCommand {
    String command;
    List<QueryCommand.ResultBatch> resultBatches;
    QueryCommand.ResultBatch resultBatch;
    long queryTimeout;

    public QueryCommandImpl(String command) {
        this.command = command;
    }

    @Override
    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(long timeout) {
        this.queryTimeout = timeout;
    }

    @Override
    public List<QueryCommand.ResultBatch> getResultBatches() {
        return this.resultBatches;
    }

    @Override
    public void execute(ProtocolImpl protocol) throws IOException {
        this.resultBatch = new QueryCommand.ResultBatch();
        this.resultBatches = new ArrayList<QueryCommand.ResultBatch>();
        QueryListener listener = new QueryListener(protocol.getContext());
        protocol.setListener(listener);
        ByteBuf msg = protocol.channel.alloc().buffer();
        protocol.writeQuery(msg, this.command);
        protocol.writeSync(msg);
        protocol.send(msg);
        this.enableCancelTimer(protocol, this.queryTimeout);
        this.waitFor(listener);
    }

    @Override
    public QueryCommand.Status getStatus() {
        return QueryCommand.Status.Completed;
    }

    @Override
    public int getMaxFieldLength() {
        return 0;
    }

    @Override
    public void setMaxFieldLength(int maxFieldLength) {
    }

    @Override
    public int getMaxRows() {
        return 0;
    }

    @Override
    public void setMaxRows(int maxRows) {
    }

    class QueryListener
    extends BaseProtocolListener {
        Context context;

        public QueryListener(Context context) {
            this.context = context;
        }

        @Override
        public boolean isComplete() {
            return !QueryCommandImpl.this.resultBatches.isEmpty() || QueryCommandImpl.this.error != null || QueryCommandImpl.this.exception != null;
        }

        @Override
        public void rowDescription(List<ResultField> resultFields) {
            QueryCommandImpl.this.resultBatch.fields = resultFields;
            QueryCommandImpl.this.resultBatch.results = !resultFields.isEmpty() ? new ArrayList() : null;
        }

        @Override
        public void rowData(ByteBuf buffer) throws IOException {
            int fieldCount = buffer.readShort();
            Object[] rowInstance = new Object[fieldCount];
            for (int c = 0; c < fieldCount; ++c) {
                Object fieldVal;
                ResultField field = QueryCommandImpl.this.resultBatch.fields.get(c);
                Type fieldType = field.typeRef.get();
                Type.Codec.Decoder decoder = fieldType.getCodec((ResultField.Format)field.format).decoder;
                rowInstance[c] = fieldVal = decoder.decode(fieldType, field.typeLength, field.typeModifier, buffer, this.context);
            }
            List<?> res = QueryCommandImpl.this.resultBatch.results;
            res.add(rowInstance);
        }

        @Override
        public void commandComplete(String command, Long rowsAffected, Long oid) {
            QueryCommandImpl.this.resultBatch.command = command;
            QueryCommandImpl.this.resultBatch.rowsAffected = rowsAffected;
            QueryCommandImpl.this.resultBatch.insertedOid = oid;
            QueryCommandImpl.this.resultBatches.add(QueryCommandImpl.this.resultBatch);
            QueryCommandImpl.this.resultBatch = new QueryCommand.ResultBatch();
        }

        @Override
        public synchronized void error(Notice error) {
            QueryCommandImpl.this.error = error;
            this.notifyAll();
        }

        @Override
        public synchronized void exception(Throwable cause) {
            QueryCommandImpl.this.setException(cause);
            this.notifyAll();
        }

        @Override
        public void notice(Notice notice) {
            QueryCommandImpl.this.addNotice(notice);
        }

        @Override
        public synchronized void ready(TransactionStatus txStatus) {
            this.notifyAll();
        }
    }
}

