/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Bytes
extends SimpleProcProvider {
    public static final BinDecoder BINARY_DECODER = new BinDecoder();
    public static final BinEncoder BINARY_ENCODER = new BinEncoder();

    public Bytes() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "bytea");
    }

    static class TxtEncoder
    extends TextEncoder {
        private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return InputStream.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            int v;
            if (val instanceof byte[]) {
                val = new ByteArrayInputStream((byte[])val);
            }
            InputStream in = (InputStream)val;
            buffer.append("\\x");
            while ((v = in.read()) > -1) {
                buffer.append(hexArray[v >>> 4]).append(hexArray[v & 0xF]);
            }
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public Class<?> getOutputType() {
            return InputStream.class;
        }

        @Override
        public InputStream decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            byte[] data = buffer.length() > 2 && buffer.charAt(0) == '\\' && buffer.charAt(1) == 'x' ? this.decodeHex(buffer.subSequence(2, buffer.length())) : this.decodeEscape(buffer);
            return new ByteArrayInputStream(data);
        }

        byte[] decodeHex(CharSequence buffer) {
            int length = buffer.length();
            byte[] data = new byte[length / 2];
            for (int i = 0; i < length; i += 2) {
                data[i / 2] = (byte)((Character.digit(buffer.charAt(i), 16) << 4) + Character.digit(buffer.charAt(i + 1), 16));
            }
            return data;
        }

        byte[] decodeEscape(CharSequence buffer) {
            int length = buffer.length();
            byte[] data = new byte[length];
            int out = 0;
            for (int i = 0; i < length; ++i) {
                char ch = buffer.charAt(i);
                switch (ch) {
                    case '\\': {
                        char ch1 = buffer.charAt(++i);
                        switch (ch1) {
                            case '\\': {
                                data[++out] = 92;
                            }
                        }
                        char ch2 = buffer.charAt(++i);
                        char ch3 = buffer.charAt(++i);
                        data[++out] = (byte)(ch1 * 64 + ch2 * 8 + ch3);
                    }
                }
                data[++out] = (byte)ch;
            }
            return Arrays.copyOf(data, out);
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return InputStream.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                int totalLength;
                InputStream in;
                if (val instanceof byte[]) {
                    val = new ByteArrayInputStream((byte[])val);
                }
                if ((in = (InputStream)val) instanceof ByteStreams.LimitedInputStream) {
                    totalLength = (int)((ByteStreams.LimitedInputStream)in).limit();
                } else if (in instanceof ByteArrayInputStream) {
                    totalLength = in.available();
                } else {
                    byte[] data = ByteStreams.toByteArray(in);
                    totalLength = data.length;
                    in = new ByteArrayInputStream(data);
                }
                buffer.writeInt(totalLength);
                long totalRead = ByteStreams.copy(in, (OutputStream)new ByteBufOutputStream(buffer));
                if ((long)totalLength != totalRead) {
                    throw new IOException("invalid stream length");
                }
            }
        }

        @Override
        public int length(Type type, Object val, Context context) throws IOException {
            int length = 4;
            if (val != null) {
                InputStream in;
                if (val instanceof byte[]) {
                    val = new ByteArrayInputStream((byte[])val);
                }
                if ((in = (InputStream)val) instanceof ByteStreams.LimitedInputStream) {
                    length += (int)((ByteStreams.LimitedInputStream)in).limit();
                } else if (in instanceof ByteArrayInputStream) {
                    length += in.available();
                } else {
                    throw new IOException("unable to compute length of InputStream type: " + val.getClass().getName());
                }
            }
            return length;
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public Class<?> getOutputType() {
            return InputStream.class;
        }

        @Override
        public InputStream decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            Integer maxLength = (Integer)context.getSetting("field.varying.length.max");
            int readLength = maxLength != null ? Math.min(maxLength, length) : length;
            final ByteBuf data = buffer.readBytes(readLength);
            buffer.skipBytes(length - readLength);
            return new ByteBufInputStream(data){

                public void close() throws IOException {
                    super.close();
                    data.release();
                }
            };
        }
    }
}

