/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;

public class Numerics
extends SimpleProcProvider {
    private static final short NUMERIC_POS = 0;
    private static final short NUMERIC_NEG = 16384;
    private static final short DEC_DIGITS = 4;

    public Numerics() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "numeric_");
    }

    private static short[] encodeFromString(String num, short[] info) {
        int ch;
        char[] numChars = num.toCharArray();
        byte[] numDigs = new byte[numChars.length - 1 + 8];
        int digs = 4;
        boolean haveDP = false;
        for (ch = 0; ch < numChars.length && numChars[ch] == '0'; ++ch) {
        }
        int sign = 0;
        int displayWeight = -1;
        int displayScale = 0;
        if (ch < numChars.length && numChars[ch] == '-') {
            sign = 16384;
            ++ch;
        }
        while (ch < numChars.length) {
            if (numChars[ch] == '.') {
                haveDP = true;
                ++ch;
                continue;
            }
            numDigs[digs++] = (byte)(numChars[ch++] - 48);
            if (!haveDP) {
                displayWeight = (short)(displayWeight + 1);
                continue;
            }
            displayScale = (short)(displayScale + 1);
        }
        short weight = displayWeight >= 0 ? (short)((displayWeight + 1 + 4 - 1) / 4 - 1) : (short)(-((-displayWeight - 1) / 4 + 1));
        int offset = (weight + 1) * 4 - (displayWeight + 1);
        int digitCount = ((digs -= 4) + offset + 4 - 1) / 4;
        int i = 4 - offset;
        short[] digits = new short[digitCount];
        int d = 0;
        while (digitCount-- > 0) {
            digits[d++] = (short)(((numDigs[i] * 10 + numDigs[i + 1]) * 10 + numDigs[i + 2]) * 10 + numDigs[i + 3]);
            i += 4;
        }
        info[0] = weight;
        info[1] = sign;
        info[2] = displayScale;
        return digits;
    }

    private static String decodeToString(short weight, short sign, short displayScale, short[] digits) {
        StringBuilder sb = new StringBuilder();
        if (sign == 16384) {
            sb.append('-');
        }
        int d = 0;
        if (weight < 0) {
            d = weight + 1;
            sb.append(0);
        } else {
            for (d = 0; d <= weight; ++d) {
                short dig = d < digits.length ? digits[d] : (short)0;
                boolean putIt = d > 0;
                for (int b = 1000; b > 1; b /= 10) {
                    short d1 = (short)(dig / b);
                    dig = (short)(dig - d1 * b);
                    if (!(putIt |= d1 > 0)) continue;
                    sb.append((char)(d1 + 48));
                }
                sb.append((char)(dig + 48));
            }
        }
        if (displayScale > 0) {
            sb.append('.');
            int length = sb.length() + displayScale;
            for (int i = 0; i < displayScale; i += 4) {
                short dig = d >= 0 && d < digits.length ? digits[d] : (short)0;
                for (int b = 1000; b > 1 && sb.length() < length; b /= 10) {
                    short d1 = (short)(dig / b);
                    dig = (short)(dig - d1 * b);
                    sb.append((char)(d1 + 48));
                }
                if (sb.length() < length) {
                    sb.append((char)(dig + 48));
                }
                ++d;
            }
        }
        return sb.toString();
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return BigDecimal.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Numeric;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            buffer.append(val.toString());
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Numeric;
        }

        @Override
        public Class<?> getOutputType() {
            return BigDecimal.class;
        }

        @Override
        public BigDecimal decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            return new BigDecimal(buffer.toString());
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return BigDecimal.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Numeric;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            buffer.writeInt(-1);
            if (val != null) {
                int writeStart = buffer.writerIndex();
                String num = ((BigDecimal)val).toPlainString();
                short[] info = new short[3];
                short[] digits = Numerics.encodeFromString(num, info);
                buffer.writeShort(digits.length);
                buffer.writeShort((int)info[0]);
                buffer.writeShort((int)info[1]);
                buffer.writeShort((int)info[2]);
                for (int d = 0; d < digits.length; ++d) {
                    buffer.writeShort((int)digits[d]);
                }
                buffer.setInt(writeStart - 4, buffer.writerIndex() - writeStart);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Numeric;
        }

        @Override
        public Class<?> getOutputType() {
            return BigDecimal.class;
        }

        @Override
        public BigDecimal decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            BigDecimal value;
            int length = buffer.readInt();
            if (length == -1) {
                value = null;
            } else {
                if (length < 8) {
                    throw new IOException("invalid length");
                }
                int readStart = buffer.readerIndex();
                short digitCount = buffer.readShort();
                short[] info = new short[]{buffer.readShort(), buffer.readShort(), buffer.readShort()};
                short[] digits = new short[digitCount];
                for (int d = 0; d < digits.length; ++d) {
                    digits[d] = buffer.readShort();
                }
                String num = Numerics.decodeToString(info[0], info[1], info[2], digits);
                if (length != buffer.readerIndex() - readStart) {
                    throw new IOException("invalid length");
                }
                value = new BigDecimal(num);
            }
            return value;
        }
    }
}

