/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.ProcProvider;
import com.impossibl.postgres.system.procs.Unknowns;
import com.impossibl.postgres.types.Modifiers;
import com.impossibl.postgres.types.Type;
import java.util.ServiceLoader;

public class Procs {
    private static final Type.Codec.Decoder[] DEFAULT_DECODERS = new Type.Codec.Decoder[]{new Unknowns.TxtDecoder(), new Unknowns.BinDecoder()};
    private static final Type.Codec.Encoder[] DEFAULT_ENCODERS = new Type.Codec.Encoder[]{new Unknowns.TxtEncoder(), new Unknowns.BinEncoder()};
    private static final Modifiers.Parser DEFAULT_MOD_PARSER = new Unknowns.ModParser();
    private ServiceLoader<ProcProvider> providers;

    public Procs(ClassLoader classLoader) {
        try {
            this.providers = ServiceLoader.load(ProcProvider.class, classLoader);
        }
        catch (Exception e) {
            this.providers = ServiceLoader.load(ProcProvider.class, Procs.class.getClassLoader());
        }
    }

    public Type.Codec.Decoder getDefaultDecoder(ResultField.Format format) {
        return DEFAULT_DECODERS[format.ordinal()];
    }

    public Type.Codec.Encoder getDefaultEncoder(ResultField.Format format) {
        return DEFAULT_ENCODERS[format.ordinal()];
    }

    public Modifiers.Parser getDefaultModParser() {
        return DEFAULT_MOD_PARSER;
    }

    public Type.Codec loadNamedTextCodec(String baseName, Context context) {
        Type.Codec codec = new Type.Codec();
        codec.encoder = this.loadEncoderProc(baseName + "in", context, DEFAULT_ENCODERS[ResultField.Format.Text.ordinal()]);
        codec.decoder = this.loadDecoderProc(baseName + "out", context, DEFAULT_DECODERS[ResultField.Format.Text.ordinal()]);
        return codec;
    }

    public Type.Codec loadNamedBinaryCodec(String baseName, Context context) {
        Type.Codec codec = new Type.Codec();
        codec.encoder = this.loadEncoderProc(baseName + "recv", context, DEFAULT_ENCODERS[ResultField.Format.Binary.ordinal()]);
        codec.decoder = this.loadDecoderProc(baseName + "send", context, DEFAULT_DECODERS[ResultField.Format.Binary.ordinal()]);
        return codec;
    }

    public Type.Codec.Encoder loadEncoderProc(String name, Context context, Type.Codec.Encoder defaultEncoder) {
        if (!name.isEmpty()) {
            for (ProcProvider pp : this.providers) {
                Type.Codec.Encoder h = pp.findEncoder(name, context);
                if (h == null) continue;
                return h;
            }
        }
        return defaultEncoder;
    }

    public Type.Codec.Decoder loadDecoderProc(String name, Context context, Type.Codec.Decoder defaultDecoder) {
        if (!name.isEmpty()) {
            for (ProcProvider pp : this.providers) {
                Type.Codec.Decoder h = pp.findDecoder(name, context);
                if (h == null) continue;
                return h;
            }
        }
        return defaultDecoder;
    }

    public Modifiers.Parser loadModifierParserProc(String name, Context context) {
        if (!name.isEmpty()) {
            for (ProcProvider pp : this.providers) {
                Modifiers.Parser p = pp.findModifierParser(name, context);
                if (p == null) continue;
                return p;
            }
        }
        return DEFAULT_MOD_PARSER;
    }
}

