/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Record;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Records
extends SimpleProcProvider {
    public Records() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "record_");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Record.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Record;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            this.writeComposite(buffer, type.getDelimeter(), (CompositeType)type, (Record)val, context);
        }

        void writeComposite(StringBuilder out, char delim, CompositeType type, Record val, Context context) throws IOException {
            out.append('(');
            Object[] vals = val.getValues();
            for (int c = 0; c < vals.length; ++c) {
                CompositeType.Attribute attr = type.getAttribute(c + 1);
                Type.Codec codec = attr.type.getCodec(ResultField.Format.Text);
                StringBuilder attrOut = new StringBuilder();
                codec.encoder.encode(attr.type, attrOut, vals[c], context);
                String attrStr = attrOut.toString();
                if (this.needsQuotes(attrStr, delim)) {
                    attrStr = attrStr.replace("\\", "\\\\");
                    attrStr = attrStr.replace("\"", "\\\"");
                    out.append('\"').append(attrStr).append('\"');
                } else {
                    out.append(attrStr);
                }
                if (c >= vals.length - 1) continue;
                out.append(delim);
            }
            out.append(')');
        }

        private boolean needsQuotes(String elemStr, char delim) {
            if (elemStr.isEmpty()) {
                return true;
            }
            if (elemStr.equalsIgnoreCase("NULL")) {
                return true;
            }
            for (int c = 0; c < elemStr.length(); ++c) {
                char ch = elemStr.charAt(c);
                if (ch != delim && ch != '\"' && ch != '\\' && ch != '{' && ch != '}' && ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') continue;
                return true;
            }
            return false;
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Record;
        }

        @Override
        public Class<?> getOutputType() {
            return Record.class;
        }

        @Override
        public Record decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            int length = buffer.length();
            Object[] instance = null;
            if (length != 0) {
                instance = this.readComposite(buffer, type.getDelimeter(), (CompositeType)type, context);
            }
            return new Record((CompositeType)type, instance);
        }

        Object readValue(CharSequence data, Type type, Context context) throws IOException {
            if (type instanceof CompositeType) {
                return this.readComposite(data, type.getDelimeter(), (CompositeType)type, context);
            }
            return type.getCodec((ResultField.Format)ResultField.Format.Text).decoder.decode(type, null, null, data, context);
        }

        Object[] readComposite(CharSequence data, char delim, CompositeType type, Context context) throws IOException {
            if (data.length() < 2 || data.charAt(0) != '(' && data.charAt(data.length() - 1) != ')') {
                return null;
            }
            data = data.subSequence(1, data.length() - 1);
            ArrayList<Object> elements = new ArrayList<Object>();
            StringBuilder elementTxt = new StringBuilder();
            int elementIdx = 1;
            boolean string = false;
            int opened = 0;
            block6: for (int c = 0; c < data.length(); ++c) {
                char ch = data.charAt(c);
                switch (ch) {
                    case '(': {
                        if (!string) {
                            ++opened;
                            continue block6;
                        }
                        elementTxt.append(ch);
                        continue block6;
                    }
                    case ')': {
                        if (!string) {
                            --opened;
                            continue block6;
                        }
                        elementTxt.append(ch);
                        continue block6;
                    }
                    case '\"': {
                        if (string && c < data.length() - 1 && data.charAt(c + 1) == '\"') {
                            elementTxt.append('\"');
                            ++c;
                            continue block6;
                        }
                        string = !string;
                        continue block6;
                    }
                    case '\\': {
                        if (!string || ++c >= data.length()) continue block6;
                        elementTxt.append(data.charAt(c));
                        continue block6;
                    }
                    default: {
                        if (ch == delim && opened == 0 && !string) {
                            Object element = this.readValue(elementTxt.toString(), type.getAttribute((int)elementIdx).type, context);
                            elements.add(element);
                            elementTxt = new StringBuilder();
                            ++elementIdx;
                            continue block6;
                        }
                        elementTxt.append(ch);
                    }
                }
            }
            Object finalElement = this.readValue(elementTxt.toString(), type.getAttribute((int)elementIdx).type, context);
            elements.add(finalElement);
            return elements.toArray();
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public Class<?> getInputType() {
            return Record.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Record;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            buffer.writeInt(-1);
            if (val != null) {
                int writeStart = buffer.writerIndex();
                Record record = (Record)val;
                Object[] attributeVals = record.getValues();
                CompositeType compType = (CompositeType)type;
                List<CompositeType.Attribute> attributes = compType.getAttributes();
                buffer.writeInt(attributes.size());
                for (CompositeType.Attribute attribute : attributes) {
                    Type attributeType = attribute.type;
                    buffer.writeInt(attributeType.getId());
                    Object attributeVal = attributeVals[attribute.number - 1];
                    attributeType.getBinaryCodec().encoder.encode(attributeType, buffer, attributeVal, context);
                }
                buffer.setInt(writeStart - 4, buffer.writerIndex() - writeStart);
            }
        }

        @Override
        public int length(Type type, Object val, Context context) throws IOException {
            int length = 4;
            if (val != null) {
                Record record = (Record)val;
                Object[] attributeVals = record.getValues();
                CompositeType compType = (CompositeType)type;
                List<CompositeType.Attribute> attributes = compType.getAttributes();
                length += 4;
                for (CompositeType.Attribute attribute : attributes) {
                    Type attributeType = attribute.type;
                    length += 4;
                    int idx = attribute.number > 0 ? attribute.number - 1 : attributes.size() + attribute.number;
                    Object attributeVal = attributeVals[idx];
                    length += attributeType.getBinaryCodec().encoder.length(attributeType, attributeVal, context);
                }
            }
            return length;
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Record;
        }

        @Override
        public Class<?> getOutputType() {
            return Record.class;
        }

        @Override
        public Object decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            CompositeType compType = (CompositeType)type;
            Record record = null;
            int length = buffer.readInt();
            if (length != -1) {
                long readStart = buffer.readerIndex();
                int itemCount = buffer.readInt();
                Object[] attributeVals = new Object[itemCount];
                for (int c = 0; c < itemCount; ++c) {
                    Object attributeVal;
                    CompositeType.Attribute attribute = compType.getAttribute(c + 1);
                    Type attributeType = context.getRegistry().loadType(buffer.readInt());
                    if (attributeType.getId() != attribute.type.getId()) {
                        context.refreshType(attributeType.getId());
                    }
                    attributeVals[c] = attributeVal = attributeType.getBinaryCodec().decoder.decode(attributeType, null, null, buffer, context);
                }
                if ((long)length != (long)buffer.readerIndex() - readStart) {
                    throw new IllegalStateException();
                }
                record = new Record(compType, attributeVals);
            }
            return record;
        }
    }
}

