/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.Modifiers;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Strings
extends SimpleProcProvider {
    public static final BinDecoder BINARY_DECODER = new BinDecoder();
    public static final BinEncoder BINARY_ENCODER = new BinEncoder();

    public Strings() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)BINARY_ENCODER, (Type.Codec.Decoder)BINARY_DECODER, new ModParser(), "text", "varchar", "bpchar", "char", "enum_", "json_", "cstring_", "citext", "unknown");
    }

    static class ModParser
    implements Modifiers.Parser {
        ModParser() {
        }

        @Override
        public Map<String, Object> parse(long mod) {
            HashMap<String, Object> mods = new HashMap<String, Object>();
            if (mod > 4L) {
                mods.put("length", (int)(mod - 4L));
            }
            return mods;
        }
    }

    public static class TxtEncoder
    extends TextEncoder {
        @Override
        public Class<?> getInputType() {
            return String.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.String;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            if (val instanceof String) {
                buffer.append((String)val);
            } else if (val.getClass() == byte[].class) {
                buffer.append(new String((byte[])val, context.getCharset()));
            } else {
                throw new IOException(val.getClass() + " cannot be encoded as a String");
            }
        }
    }

    public static class TxtDecoder
    extends TextDecoder {
        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.String;
        }

        @Override
        public Class<?> getOutputType() {
            return String.class;
        }

        @Override
        public String decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            return buffer.toString();
        }
    }

    public static class BinEncoder
    extends BinaryEncoder {
        @Override
        public Class<?> getInputType() {
            return String.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.String;
        }

        byte[] toBytes(Object val, Context context) {
            return val.toString().getBytes(context.getCharset());
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                byte[] bytes = this.toBytes(val, context);
                buffer.writeInt(bytes.length);
                buffer.writeBytes(bytes);
            }
        }

        @Override
        public int length(Type type, Object val, Context context) throws IOException {
            return val == null ? 4 : 4 + this.toBytes(val, context).length;
        }
    }

    public static class BinDecoder
    extends BinaryDecoder {
        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.String;
        }

        @Override
        public Class<?> getOutputType() {
            return String.class;
        }

        @Override
        public String decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            Integer maxLength = (Integer)context.getSetting("field.varying.length.max");
            byte[] bytes = maxLength != null ? new byte[Math.min(maxLength, length)] : new byte[length];
            buffer.readBytes(bytes);
            buffer.skipBytes(length - bytes.length);
            return new String(bytes, context.getCharset());
        }
    }
}

