/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Tid;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class Tids
extends SimpleProcProvider {
    public Tids() {
        super((Type.Codec.Encoder)new TxtEncoder(), (Type.Codec.Decoder)new TxtDecoder(), (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "tid");
    }

    static class TxtEncoder
    extends TextEncoder {
        TxtEncoder() {
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Tid;
        }

        @Override
        public Class<?> getInputType() {
            return Tid.class;
        }

        @Override
        protected void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            Tid tid = (Tid)val;
            buffer.append('(').append(tid.block).append(',').append(tid.offset).append(')');
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        TxtDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Tid;
        }

        @Override
        public Class<?> getOutputType() {
            return Tid.class;
        }

        @Override
        protected Tid decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            String[] items = buffer.subSequence(1, buffer.length() - 1).toString().split(",");
            int block = Integer.parseInt(items[0]);
            short offset = Short.parseShort(items[1]);
            return new Tid(block, offset);
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        BinEncoder() {
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Tid;
        }

        @Override
        public Class<?> getInputType() {
            return Tid.class;
        }

        @Override
        protected void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                Tid tid = (Tid)val;
                buffer.writeInt(6);
                buffer.writeInt(tid.block);
                buffer.writeShort((int)tid.offset);
            }
        }

        @Override
        public int length(Type type, Object val, Context context) throws IOException {
            return val == null ? 4 : 10;
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        BinDecoder() {
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Tid;
        }

        @Override
        public Class<?> getOutputType() {
            return Tid.class;
        }

        @Override
        protected Object decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 6) {
                throw new IOException("invalid length");
            }
            int block = buffer.readInt();
            short offset = buffer.readShort();
            return new Tid(block, offset);
        }
    }
}

