/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.procs.Procs;
import com.impossibl.postgres.system.tables.PgAttribute;
import com.impossibl.postgres.system.tables.PgType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class CompositeType
extends Type {
    private List<Attribute> attributes;

    public CompositeType(int id, String name, int arrayTypeId, String procName, Procs procs) {
        super(id, name, null, null, Type.Category.Composite, ',', arrayTypeId, procs.loadNamedBinaryCodec(procName, null), procs.loadNamedTextCodec(procName, null));
    }

    public CompositeType(int id, String name, int arrayTypeId, Procs procs) {
        this(id, name, arrayTypeId, "record_", procs);
    }

    public CompositeType() {
    }

    public Attribute getAttribute(int number) {
        if (number > 0 && number <= this.attributes.size() && this.attributes.get((int)(number - 1)).number == number) {
            return this.attributes.get(number - 1);
        }
        int sz = this.attributes.size();
        for (int c = 0; c < sz; ++c) {
            Attribute attr = this.attributes.get(c);
            if (attr.number != number) continue;
            return attr;
        }
        return null;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public boolean isParameterFormatSupported(ResultField.Format format) {
        boolean allSupported = super.isParameterFormatSupported(format);
        for (Attribute attr : this.attributes) {
            allSupported &= attr.type.isParameterFormatSupported(format);
        }
        return allSupported;
    }

    @Override
    public boolean isResultFormatSupported(ResultField.Format format) {
        boolean allSupported = super.isResultFormatSupported(format);
        for (Attribute attr : this.attributes) {
            allSupported &= attr.type.isResultFormatSupported(format);
        }
        return allSupported;
    }

    @Override
    public Class<?> getJavaType(ResultField.Format format, Map<String, Class<?>> customizations) {
        Class<?> type;
        Class<?> clazz = type = customizations != null ? customizations.get(this.getName()) : null;
        if (type == null) {
            type = super.getJavaType(format, customizations);
        }
        return type;
    }

    @Override
    public void load(PgType.Row pgType, Collection<PgAttribute.Row> pgAttrs, Registry registry) {
        super.load(pgType, pgAttrs, registry);
        if (pgAttrs == null) {
            this.attributes = Collections.emptyList();
        } else {
            this.attributes = new ArrayList<Attribute>(pgAttrs.size());
            for (PgAttribute.Row pgAttr : pgAttrs) {
                Attribute attr = new Attribute();
                attr.number = pgAttr.number;
                attr.name = pgAttr.name;
                attr.type = registry.loadType(pgAttr.typeId);
                attr.nullable = pgAttr.nullable;
                attr.hasDefault = pgAttr.hasDefault;
                attr.typeModifiers = attr.type != null ? attr.type.getModifierParser().parse(pgAttr.typeModifier) : Collections.emptyMap();
                attr.autoIncrement = pgAttr.autoIncrement;
                this.attributes.add(attr);
            }
            Collections.sort(this.attributes, new Comparator<Attribute>(){

                @Override
                public int compare(Attribute o1, Attribute o2) {
                    int o1n = o1.number < 0 ? o1.number + Integer.MAX_VALUE : o1.number;
                    int o2n = o2.number < 0 ? o2.number + Integer.MAX_VALUE : o2.number;
                    return o1n - o2n;
                }
            });
        }
    }

    public static class Attribute {
        public int number;
        public String name;
        public Type type;
        public boolean nullable;
        public boolean autoIncrement;
        public boolean hasDefault;
        public Map<String, Object> typeModifiers;

        public String toString() {
            return this.name + " : " + this.type;
        }
    }
}

