/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.Procs;
import com.impossibl.postgres.system.tables.PgAttribute;
import com.impossibl.postgres.system.tables.PgProc;
import com.impossibl.postgres.system.tables.PgType;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.BaseType;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.DomainType;
import com.impossibl.postgres.types.EnumerationType;
import com.impossibl.postgres.types.Modifiers;
import com.impossibl.postgres.types.PsuedoType;
import com.impossibl.postgres.types.RangeType;
import com.impossibl.postgres.types.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public class Registry {
    private static Logger logger = Logger.getLogger(Registry.class.getName());
    private Map<Character, Class<? extends Type>> kindMap;
    private TreeMap<Integer, Type> oidMap;
    private Map<String, Type> nameMap;
    private TreeMap<Integer, Type> relIdMap;
    private TreeMap<Integer, PgType.Row> pgTypeData;
    private TreeMap<Integer, Collection<PgAttribute.Row>> pgAttrData;
    private TreeMap<Integer, PgProc.Row> pgProcData;
    private Map<String, PgProc.Row> pgProcNameMap;
    private Context context;
    private Procs procs;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, String> typeNameAliases;

    public Registry(Context context) {
        this.context = context;
        this.procs = new Procs(context.getClass().getClassLoader());
        this.pgTypeData = new TreeMap();
        this.pgAttrData = new TreeMap();
        this.pgProcData = new TreeMap();
        this.pgProcNameMap = new HashMap<String, PgProc.Row>();
        this.kindMap = new HashMap<Character, Class<? extends Type>>();
        this.kindMap.put(Character.valueOf('c'), CompositeType.class);
        this.kindMap.put(Character.valueOf('d'), DomainType.class);
        this.kindMap.put(Character.valueOf('e'), EnumerationType.class);
        this.kindMap.put(Character.valueOf('p'), PsuedoType.class);
        this.kindMap.put(Character.valueOf('r'), RangeType.class);
        this.oidMap = new TreeMap();
        this.oidMap.put(16, new BaseType(16, "bool", (Short)1, (Byte)0, Type.Category.Boolean, ',', 0, "bool", this.procs));
        this.oidMap.put(17, new BaseType(17, "bytea", (Short)1, (Byte)0, Type.Category.User, ',', 0, "bytea", this.procs));
        this.oidMap.put(18, new BaseType(18, "char", (Short)1, (Byte)0, Type.Category.String, ',', 0, "char", this.procs));
        this.oidMap.put(19, new BaseType(19, "name", (Short)64, (Byte)0, Type.Category.String, ',', 0, "name", this.procs));
        this.oidMap.put(21, new BaseType(21, "int2", (Short)2, (Byte)0, Type.Category.Numeric, ',', 0, "int2", this.procs));
        this.oidMap.put(23, new BaseType(23, "int4", (Short)4, (Byte)0, Type.Category.Numeric, ',', 0, "int4", this.procs));
        this.oidMap.put(24, new BaseType(24, "regproc", (Short)4, (Byte)0, Type.Category.Numeric, ',', 0, "regproc", this.procs));
        this.oidMap.put(25, new BaseType(25, "text", (Short)1, (Byte)0, Type.Category.String, ',', 0, "text", this.procs));
        this.oidMap.put(26, new BaseType(26, "oid", (Short)4, (Byte)0, Type.Category.Numeric, ',', 0, "oid", this.procs));
        this.relIdMap = new TreeMap();
        this.nameMap = new HashMap<String, Type>();
        this.typeNameAliases = new HashMap<String, String>();
        this.typeNameAliases.put("smallint", "int2");
        this.typeNameAliases.put("integer", "int4");
        this.typeNameAliases.put("bigint", "int8");
        this.typeNameAliases.put("decimal", "numeric");
        this.typeNameAliases.put("real", "float4");
        this.typeNameAliases.put("double precision", "float8");
        this.typeNameAliases.put("smallserial", "int2");
        this.typeNameAliases.put("serial", "int4");
        this.typeNameAliases.put("bigserial", "int8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type loadType(int typeId) {
        if (typeId == 0) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            Type type = this.oidMap.get(typeId);
            if (type == null) {
                this.lock.readLock().unlock();
                try {
                    type = this.loadRaw(typeId);
                    if (type == null) {
                        this.context.refreshType(typeId);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                }
                type = this.oidMap.get(typeId);
            }
            Type type2 = type;
            return type2;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type loadType(String name) {
        Type res;
        String alias;
        boolean isArray = false;
        if (name.endsWith("[]")) {
            isArray = true;
            name = name.substring(0, name.length() - 2);
        }
        if ((alias = this.typeNameAliases.get(name)) != null) {
            name = alias;
        }
        this.lock.readLock().lock();
        try {
            res = this.nameMap.get(name);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (res == null) {
            this.context.refreshType(this.getLatestKnownTypeId() + 1);
            this.lock.readLock().lock();
            try {
                res = this.nameMap.get(name);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        if (isArray && res != null) {
            res = this.loadType(res.getArrayTypeId());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeType loadRelationType(int relationId) {
        if (relationId == 0) {
            return null;
        }
        this.lock.readLock().lock();
        try {
            CompositeType type = (CompositeType)this.relIdMap.get(relationId);
            if (type == null) {
                this.lock.readLock().unlock();
                try {
                    type = this.loadRelationRaw(relationId);
                    if (type == null) {
                        this.context.refreshRelationType(relationId);
                    }
                }
                finally {
                    this.lock.readLock().lock();
                }
                type = (CompositeType)this.relIdMap.get(relationId);
            }
            CompositeType compositeType = type;
            return compositeType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void unloadType(int oid) {
        Type type = this.oidMap.remove(oid);
        if (type != null) {
            this.nameMap.remove(type.getName());
        }
    }

    public void unloadType(String name) {
        Type type = this.nameMap.remove(name);
        if (type != null) {
            this.oidMap.remove(type.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lookupProcName(int procId) {
        this.lock.readLock().lock();
        try {
            PgProc.Row pgProc = this.pgProcData.get(procId);
            if (pgProc == null) {
                String string = null;
                return string;
            }
            String string = pgProc.name;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lookupProcId(String procName) {
        this.lock.readLock().lock();
        try {
            PgProc.Row pgProc = this.pgProcNameMap.get(procName);
            if (pgProc == null) {
                int n = 0;
                return n;
            }
            int n = pgProc.oid;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getLatestKnownTypeId() {
        return this.oidMap.lastKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<PgType.Row> pgTypeRows, Collection<PgAttribute.Row> pgAttrRows, Collection<PgProc.Row> pgProcRows) {
        this.lock.writeLock().lock();
        try {
            for (PgType.Row pgType : pgTypeRows) {
                this.pgAttrData.remove(pgType.relationId);
            }
            for (PgAttribute.Row pgAttrRow : pgAttrRows) {
                Collection<PgAttribute.Row> relRows = this.pgAttrData.get(pgAttrRow.relationId);
                if (relRows == null) {
                    relRows = new HashSet<PgAttribute.Row>();
                    this.pgAttrData.put(pgAttrRow.relationId, relRows);
                }
                relRows.add(pgAttrRow);
            }
            for (PgProc.Row pgProcRow : pgProcRows) {
                this.pgProcData.put(pgProcRow.oid, pgProcRow);
                this.pgProcNameMap.put(pgProcRow.name, pgProcRow);
            }
            for (PgType.Row pgTypeRow : pgTypeRows) {
                this.pgTypeData.put(pgTypeRow.oid, pgTypeRow);
                this.oidMap.remove(pgTypeRow.oid);
                this.nameMap.remove(pgTypeRow.name);
                this.relIdMap.remove(pgTypeRow.relationId);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (PgType.Row pgType : pgTypeRows) {
            this.loadType(pgType.oid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type loadRaw(int typeId) {
        if (typeId == 0) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            Type type;
            PgType.Row pgType = this.pgTypeData.get(typeId);
            if (pgType == null) {
                Type type2 = null;
                return type2;
            }
            Collection<PgAttribute.Row> pgAttrs = this.pgAttrData.get(pgType.relationId);
            this.lock.writeLock().unlock();
            try {
                type = this.loadRaw(pgType, pgAttrs);
            }
            finally {
                this.lock.writeLock().lock();
            }
            if (type != null) {
                this.oidMap.put(typeId, type);
                this.nameMap.put(type.getName(), type);
                this.relIdMap.put(type.getRelationId(), type);
            }
            Type type3 = type;
            return type3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeType loadRelationRaw(int relationId) {
        if (relationId == 0) {
            return null;
        }
        this.lock.writeLock().lock();
        try {
            CompositeType type = null;
            Collection<PgAttribute.Row> pgAttrs = this.pgAttrData.get(relationId);
            if (pgAttrs != null && !pgAttrs.isEmpty()) {
                PgType.Row pgType = this.pgTypeData.get(pgAttrs.iterator().next().relationTypeId);
                if (pgType == null) {
                    CompositeType compositeType = null;
                    return compositeType;
                }
                this.lock.writeLock().unlock();
                try {
                    type = (CompositeType)this.loadRaw(pgType, pgAttrs);
                }
                finally {
                    this.lock.writeLock().lock();
                }
                if (type != null) {
                    this.oidMap.put(pgType.oid, type);
                    this.nameMap.put(type.getName(), type);
                    this.relIdMap.put(type.getRelationId(), type);
                }
            }
            CompositeType compositeType = type;
            return compositeType;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type loadRaw(PgType.Row pgType, Collection<PgAttribute.Row> pgAttrs) {
        Type type;
        if (pgType.elementTypeId != 0 && pgType.category.equals("A")) {
            ArrayType array = new ArrayType();
            array.setElementType(this.loadType(pgType.elementTypeId));
            type = array;
        } else {
            switch (pgType.discriminator.charAt(0)) {
                case 'b': {
                    type = new BaseType();
                    break;
                }
                case 'c': {
                    type = new CompositeType();
                    break;
                }
                case 'd': {
                    type = new DomainType();
                    break;
                }
                case 'e': {
                    type = new EnumerationType();
                    break;
                }
                case 'p': {
                    type = new PsuedoType();
                    break;
                }
                case 'r': {
                    type = new RangeType();
                    break;
                }
                default: {
                    logger.warning("unknown discriminator (aka 'typtype') found in pg_type table");
                    return null;
                }
            }
        }
        try {
            this.lock.writeLock().lock();
            try {
                this.oidMap.put(pgType.oid, type);
            }
            finally {
                this.lock.writeLock().unlock();
            }
            type.load(pgType, pgAttrs, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.lock.writeLock().lock();
            try {
                this.oidMap.remove(pgType.oid);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return type;
    }

    public Type.Codec loadCodec(int encoderId, int decoderId, ResultField.Format format) {
        Type.Codec io = new Type.Codec();
        io.decoder = this.loadDecoderProc(decoderId, this.procs.getDefaultDecoder(format));
        io.encoder = this.loadEncoderProc(encoderId, this.procs.getDefaultEncoder(format));
        return io;
    }

    private Type.Codec.Encoder loadEncoderProc(int procId, Type.Codec.Encoder defaultEncoder) {
        String name = this.lookupProcName(procId);
        if (name == null) {
            return defaultEncoder;
        }
        return this.procs.loadEncoderProc(name, this.context, defaultEncoder);
    }

    private Type.Codec.Decoder loadDecoderProc(int procId, Type.Codec.Decoder defaultDecoder) {
        String name = this.lookupProcName(procId);
        if (name == null) {
            return defaultDecoder;
        }
        return this.procs.loadDecoderProc(name, this.context, defaultDecoder);
    }

    public Modifiers.Parser loadModifierParser(int modInId, int modOutId) {
        String name = this.lookupProcName(modInId);
        if (name == null) {
            name = "";
        }
        return this.procs.loadModifierParserProc(name, this.context);
    }
}

