/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.tables.PgAttribute;
import com.impossibl.postgres.system.tables.PgType;
import com.impossibl.postgres.types.Modifiers;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Registry;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public abstract class Type {
    private int id;
    private String name;
    private String namespace;
    private Short length;
    private Byte alignment;
    private Category category;
    private Character delimeter;
    private int arrayTypeId;
    private int relationId;
    private Codec[] codecs;
    private Modifiers.Parser modifierParser;

    public Type() {
    }

    public Type(int id, String name, Short length, Byte alignment, Category category, char delimeter, int arrayTypeId, Codec binaryCodec, Codec textCodec) {
        this.id = id;
        this.name = name;
        this.length = length;
        this.alignment = alignment;
        this.category = category;
        this.delimeter = Character.valueOf(delimeter);
        this.arrayTypeId = arrayTypeId;
        this.codecs = new Codec[]{textCodec, binaryCodec};
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Short getLength() {
        return this.length;
    }

    public void setLength(Short length) {
        this.length = length;
    }

    public Byte getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Byte alignment) {
        this.alignment = alignment;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public char getDelimeter() {
        return this.delimeter.charValue();
    }

    public void setDelimeter(char delimeter) {
        this.delimeter = Character.valueOf(delimeter);
    }

    public int getArrayTypeId() {
        return this.arrayTypeId;
    }

    public void setArrayTypeId(int arrayTypeId) {
        this.arrayTypeId = arrayTypeId;
    }

    public Codec getBinaryCodec() {
        return this.codecs[ResultField.Format.Binary.ordinal()];
    }

    public void setBinaryCodec(Codec binaryCodec) {
        this.codecs[ResultField.Format.Binary.ordinal()] = binaryCodec;
    }

    public Codec getTextCodec() {
        return this.codecs[ResultField.Format.Text.ordinal()];
    }

    public void setTextCodec(Codec textCodec) {
        this.codecs[ResultField.Format.Text.ordinal()] = textCodec;
    }

    public Codec getCodec(ResultField.Format format) {
        return this.codecs[format.ordinal()];
    }

    public Modifiers.Parser getModifierParser() {
        return this.modifierParser;
    }

    public void setModifierParser(Modifiers.Parser modifierParser) {
        this.modifierParser = modifierParser;
    }

    public int getRelationId() {
        return this.relationId;
    }

    public void setRelationId(int relationId) {
        this.relationId = relationId;
    }

    public Type unwrap() {
        return this;
    }

    public PrimitiveType getPrimitiveType() {
        Codec binCodec = this.getBinaryCodec();
        if (binCodec.decoder.getInputPrimitiveType() != null) {
            return binCodec.decoder.getInputPrimitiveType();
        }
        Codec txtCodec = this.getTextCodec();
        if (txtCodec.decoder.getInputPrimitiveType() != null) {
            return txtCodec.decoder.getInputPrimitiveType();
        }
        return PrimitiveType.Unknown;
    }

    public Class<?> getJavaType(ResultField.Format format, Map<String, Class<?>> customizations) {
        Codec codec = this.getCodec(format);
        if (codec.decoder.getInputPrimitiveType() != PrimitiveType.Unknown) {
            return codec.decoder.getOutputType();
        }
        return String.class;
    }

    public ResultField.Format getPreferredFormat() {
        if (this.isParameterFormatSupported(ResultField.Format.Binary) && this.isResultFormatSupported(ResultField.Format.Binary)) {
            return ResultField.Format.Binary;
        }
        return ResultField.Format.Text;
    }

    public boolean isParameterFormatSupported(ResultField.Format format) {
        return this.getCodec((ResultField.Format)format).encoder.getOutputPrimitiveType() != PrimitiveType.Unknown;
    }

    public ResultField.Format getParameterFormat() {
        if (this.isParameterFormatSupported(ResultField.Format.Binary)) {
            return ResultField.Format.Binary;
        }
        if (this.isParameterFormatSupported(ResultField.Format.Text)) {
            return ResultField.Format.Text;
        }
        throw new IllegalStateException("type has no supported parameter format: " + this.toString());
    }

    public boolean isResultFormatSupported(ResultField.Format format) {
        return this.getCodec((ResultField.Format)format).decoder.getInputPrimitiveType() != PrimitiveType.Unknown;
    }

    public ResultField.Format getResultFormat() {
        if (this.isResultFormatSupported(ResultField.Format.Binary)) {
            return ResultField.Format.Binary;
        }
        return ResultField.Format.Text;
    }

    public void load(PgType.Row source, Collection<PgAttribute.Row> attrs, Registry registry) {
        this.id = source.oid;
        this.name = source.name;
        this.namespace = source.namespace;
        this.length = source.length != -1 ? Short.valueOf(source.length) : null;
        this.alignment = Type.getAlignment(source.alignment != null ? Character.valueOf(source.alignment.charAt(0)) : null);
        this.category = Category.findValue(source.category);
        this.delimeter = source.deliminator != null ? Character.valueOf(source.deliminator.charAt(0)) : null;
        this.arrayTypeId = source.arrayTypeId;
        this.relationId = source.relationId;
        this.codecs = new Codec[]{registry.loadCodec(source.inputId, source.outputId, ResultField.Format.Text), registry.loadCodec(source.receiveId, source.sendId, ResultField.Format.Binary)};
        this.modifierParser = registry.loadModifierParser(source.modInId, source.modOutId);
    }

    public static Byte getAlignment(Character align) {
        if (align == null) {
            return null;
        }
        switch (align.charValue()) {
            case 'c': {
                return (byte)1;
            }
            case 's': {
                return (byte)2;
            }
            case 'i': {
                return (byte)4;
            }
            case 'd': {
                return (byte)8;
            }
        }
        throw new IllegalStateException("invalid alignment character: " + align);
    }

    public String toString() {
        return this.name + '(' + this.id + ')';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return this.id == other.id;
    }

    public static class Codec {
        public Decoder decoder;
        public Encoder encoder;

        public static interface Encoder {
            public Class<?> getInputType();

            public PrimitiveType getOutputPrimitiveType();

            public void encode(Type var1, Object var2, Object var3, Context var4) throws IOException;

            public int length(Type var1, Object var2, Context var3) throws IOException;
        }

        public static interface Decoder {
            public PrimitiveType getInputPrimitiveType();

            public Class<?> getOutputType();

            public Object decode(Type var1, Short var2, Integer var3, Object var4, Context var5) throws IOException;
        }
    }

    public static enum Category {
        Array('A'),
        Boolean('B'),
        Composite('C'),
        DateTime('D'),
        Enumeration('E'),
        Geometry('G'),
        NetworkAddress('I'),
        Numeric('N'),
        Psuedo('P'),
        Range('R'),
        String('S'),
        Timespan('T'),
        User('U'),
        BitString('V'),
        Unknown('X');

        private char id;

        private Category(char id) {
            this.id = id;
        }

        public char getId() {
            return this.id;
        }

        public static Category findValue(String id) {
            if (id == null || id.isEmpty()) {
                return null;
            }
            for (Category cat : Category.values()) {
                if (cat.id != id.charAt(0)) continue;
                return cat;
            }
            return null;
        }
    }
}

