/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class StreamingByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator allocator;
    private final ByteOrder endianness;
    private ByteBuf buffer;
    private Channel streamChannel;
    private ChannelFuture lastStreamChannelWrite;
    private int totalWritten;

    public StreamingByteBuf(Channel streamChannel, int estimatedLength) {
        this(streamChannel, ByteOrder.BIG_ENDIAN, estimatedLength);
    }

    public StreamingByteBuf(Channel streamChannel, ByteOrder endianness, int estimatedLength) {
        this(streamChannel, endianness, estimatedLength, streamChannel.alloc());
    }

    public StreamingByteBuf(Channel streamChannel, ByteOrder endianness, int estimatedLength, ByteBufAllocator allocator) {
        super(Integer.MAX_VALUE);
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        if (endianness == null) {
            throw new NullPointerException("endianness");
        }
        if (allocator == null) {
            throw new NullPointerException("allocator");
        }
        this.allocator = allocator;
        this.endianness = endianness;
        this.streamChannel = streamChannel;
        this.buffer = allocator.buffer(estimatedLength).order(endianness);
    }

    public void flush() {
        this.ensureWritable(this.buffer.capacity());
    }

    public ByteBuf resetReaderIndex() {
        throw new InvalidMarkException();
    }

    public ByteBuf resetWriterIndex() {
        throw new InvalidMarkException();
    }

    public ByteBuf unwrap() {
        return this.buffer;
    }

    public int getTotalLength() {
        return this.totalWritten + this.readableBytes();
    }

    public ByteBuf ensureWritable(int minWritableBytes) {
        if (minWritableBytes > this.buffer.capacity()) {
            throw new IllegalArgumentException("illegal write size");
        }
        if (minWritableBytes <= this.writableBytes()) {
            return this;
        }
        if (this.lastStreamChannelWrite != null) {
            this.lastStreamChannelWrite.syncUninterruptibly();
        }
        this.totalWritten += this.readableBytes();
        ByteBuf replacement = this.alloc().buffer(this.buffer.capacity()).order(this.order());
        this.buffer.setIndex(this.readerIndex(), this.writerIndex());
        this.lastStreamChannelWrite = this.streamChannel.writeAndFlush((Object)this.buffer);
        this.buffer = replacement;
        this.clear();
        return this;
    }

    public ByteBufAllocator alloc() {
        return this.allocator;
    }

    public ByteOrder order() {
        return this.endianness;
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public int getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.buffer.getBytes(index, out, length);
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.buffer.getBytes(index, out, length);
        return this;
    }

    public ByteBuf setByte(int index, int value) {
        this.buffer.setByte(index, value);
        return this;
    }

    public ByteBuf setShort(int index, int value) {
        this.buffer.setShort(index, value);
        return this;
    }

    public ByteBuf setMedium(int index, int value) {
        this.buffer.setMedium(index, value);
        return this;
    }

    public ByteBuf setInt(int index, int value) {
        this.buffer.setInt(index, value);
        return this;
    }

    public ByteBuf setLong(int index, long value) {
        this.buffer.setLong(index, value);
        return this;
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
        return this;
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.buffer.setBytes(index, in, length);
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.buffer.setBytes(index, in, length);
    }

    public ByteBuf writeByte(int value) {
        this.ensureWritable(1);
        super.writeByte(value);
        return this;
    }

    public ByteBuf writeShort(int value) {
        this.ensureWritable(2);
        super.writeShort(value);
        return this;
    }

    public ByteBuf writeMedium(int value) {
        this.ensureWritable(3);
        super.writeMedium(value);
        return this;
    }

    public ByteBuf writeInt(int value) {
        this.ensureWritable(4);
        super.writeInt(value);
        return this;
    }

    public ByteBuf writeLong(long value) {
        this.ensureWritable(8);
        super.writeLong(value);
        return this;
    }

    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.ensureWritable(length);
        super.writeBytes(src, srcIndex, length);
        return this;
    }

    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        this.ensureWritable(length);
        super.writeBytes(src, srcIndex, length);
        return this;
    }

    public ByteBuf writeBytes(ByteBuffer src) {
        this.ensureWritable(src.remaining());
        super.writeBytes(src);
        return this;
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        this.ensureWritable(length);
        return super.writeBytes(in, length);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        this.ensureWritable(length);
        return super.writeBytes(in, length);
    }

    public ByteBuf writeZero(int length) {
        this.ensureWritable(length);
        super.writeZero(length);
        return this;
    }

    public ByteBuf duplicate() {
        return new DuplicatedByteBuf((ByteBuf)this);
    }

    public ByteBuf copy(int index, int length) {
        return null;
    }

    public ByteBuf slice(int index, int length) {
        return null;
    }

    public ByteBuffer nioBuffer(int index, int length) {
        return null;
    }

    protected byte _getByte(int index) {
        return this.buffer.getByte(index);
    }

    protected short _getShort(int index) {
        return this.buffer.getShort(index);
    }

    protected int _getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    protected int _getInt(int index) {
        return this.buffer.getInt(index);
    }

    protected long _getLong(int index) {
        return this.buffer.getLong(index);
    }

    protected void _setByte(int index, int value) {
        this.buffer.setByte(index, value);
    }

    protected void _setShort(int index, int value) {
        this.buffer.setShort(index, value);
    }

    protected void _setMedium(int index, int value) {
        this.buffer.setMedium(index, value);
    }

    protected void _setInt(int index, int value) {
        this.buffer.setInt(index, value);
    }

    protected void _setLong(int index, long value) {
        this.buffer.setLong(index, value);
    }

    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException();
    }

    public int nioBufferCount() {
        return 0;
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    protected void deallocate() {
        this.buffer.release();
    }
}

