/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime;

import com.impossibl.postgres.api.data.Interval;
import com.impossibl.postgres.datetime.IntervalFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.Period;
import java.util.Locale;
import java.util.StringTokenizer;

public class PostgresIntervalFormat
implements IntervalFormat {
    private DecimalFormat secondsFormat = new DecimalFormat("0.00####", DecimalFormatSymbols.getInstance(Locale.ROOT));

    private Interval parse(CharSequence chars) {
        String value = chars.toString();
        boolean isVerbose = value.startsWith("@");
        if (isVerbose && value.length() == 3 && value.charAt(2) == '0') {
            return Interval.of(Duration.ofSeconds(0L));
        }
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        double seconds = 0.0;
        boolean ago = false;
        try {
            String changedValue = value.replace('+', ' ').replace('@', ' ');
            StringTokenizer st = new StringTokenizer(changedValue);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals("ago")) {
                    ago = true;
                    break;
                }
                int endHours = token.indexOf(58);
                if (endHours != -1) {
                    int offset = token.charAt(0) == '-' ? 1 : 0;
                    hours = Integer.parseInt(token.substring(offset + 0, endHours));
                    minutes = Integer.parseInt(token.substring(endHours + 1, endHours + 3));
                    int endMinutes = token.indexOf(58, endHours + 1);
                    if (endMinutes != -1) {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
                        seconds = numberFormat.parse(token.substring(endMinutes + 1)).doubleValue();
                    }
                    if (offset == 1) {
                        hours = -hours;
                        minutes = -minutes;
                        seconds = -seconds;
                    }
                    break;
                }
                String valueToken = token;
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("invalid interval");
                }
                token = st.nextToken();
                if (token.startsWith("year")) {
                    years = Integer.parseInt(valueToken);
                    continue;
                }
                if (token.startsWith("mon")) {
                    months = Integer.parseInt(valueToken);
                    continue;
                }
                if (token.startsWith("day")) {
                    days = Integer.parseInt(valueToken);
                    continue;
                }
                if (token.startsWith("hour")) {
                    hours = Integer.parseInt(valueToken);
                    continue;
                }
                if (token.startsWith("min")) {
                    minutes = Integer.parseInt(valueToken);
                    continue;
                }
                if (!token.startsWith("sec")) continue;
                seconds = Double.parseDouble(valueToken);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("invalid interval", e);
        }
        if (isVerbose && ago) {
            years = -years;
            months = -months;
            days = -days;
            hours = -hours;
            minutes = -minutes;
            seconds = -seconds;
        }
        Period period = Period.of(years, months, days);
        Duration duration = Duration.ofHours(hours).plusMinutes(minutes).plusNanos((long)(seconds * 1.0E9));
        return Interval.of(period, duration);
    }

    private String print(Interval interval) {
        StringBuilder buffer = new StringBuilder();
        Period period = interval.getPeriod();
        Duration duration = interval.getDuration();
        long hours = duration.toHours();
        long minutes = duration.minusHours(duration.toHours()).toMinutes();
        long seconds = duration.minusMinutes(duration.toMinutes()).getSeconds();
        double fullSeconds = (double)seconds + (double)duration.getNano() / 1.0E9;
        return buffer.append("@ ").append(period.getYears()).append(" years ").append(period.getMonths()).append(" months ").append(period.getDays()).append(" days ").append(hours).append(" hours ").append(minutes).append(" minutes ").append(this.secondsFormat.format(fullSeconds)).append(" seconds").toString();
    }

    @Override
    public IntervalFormat.Parser getParser() {
        return this::parse;
    }

    @Override
    public IntervalFormat.Printer getPrinter() {
        return this::print;
    }
}

