/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.BatchResults;
import com.impossibl.postgres.jdbc.ErrorUtils;
import java.sql.BatchUpdateException;
import java.util.Arrays;

class IntegerBatchResults
implements BatchResults {
    int[] counts = new int[0];
    boolean strict;

    IntegerBatchResults(boolean strict) {
        this.strict = strict;
    }

    @Override
    public void setBatchSize(int size) {
        this.counts = new int[size];
        Arrays.fill(this.counts, -2);
    }

    @Override
    public void setUpdateCount(int batchIdx, long count) {
        this.counts[batchIdx] = (int)Long.min(count, Integer.MAX_VALUE);
    }

    @Override
    public BatchUpdateException getException(int batchIdx, String message, Exception cause) {
        int[] counts;
        if (this.strict) {
            counts = Arrays.copyOf(this.counts, batchIdx);
        } else {
            counts = Arrays.copyOf(this.counts, batchIdx + 1);
            counts[batchIdx] = -3;
        }
        return new BatchUpdateException(message, null, 0, counts, (Throwable)(cause != null ? ErrorUtils.makeSQLException(cause) : null));
    }
}

