/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.JDBCSettings;
import com.impossibl.postgres.system.Setting;
import java.util.function.Function;

interface JDBCSettingsInit {
    public static void init() {
        JDBCSettings.JDBC.init("jdbc", "JDBC Settings", true);
        JDBCSettings.CLIENT_INFO.init("jdbc-client-info", "Settings allowed to be referenced as connection client-info", false);
        JDBCSettings.READ_ONLY.init("jdbc", "Connect in read-only mode", Boolean.class, "false", Boolean::parseBoolean, Object::toString, new String[]{"read-only", "readOnly"});
        JDBCSettings.PARSED_SQL_CACHE_SIZE.init("jdbc", "Size of the parsed SQL text cache.\n\nA value of zero disables the cache.", Integer.class, "250", str -> JDBCSettingsInit.checkRange("parsed-sql.cache.size", Integer.parseInt(str), 0, null), Object::toString, new String[]{"parsed-sql.cache.size", "parsedSqlCacheSize"});
        JDBCSettings.PREPARED_STATEMENT_CACHE_SIZE.init("jdbc", "Size of the prepared statement cache\n\nA value of zero disables the cache.", Integer.class, "50", str -> JDBCSettingsInit.checkRange("prepared-statement.cache.size", Integer.parseInt(str), 0, null), Object::toString, new String[]{"prepared-statement.cache.size", "preparedStatementCacheSize"});
        JDBCSettings.PREPARED_STATEMENT_CACHE_THRESHOLD.init("jdbc", "# of times a query is seen before it is cached as a prepared statement.\n\nA value of zero prepares all statements in advance.", Integer.class, "0", str -> JDBCSettingsInit.checkRange("prepared-statement.cache.threshold", Integer.parseInt(str), 0, null), Object::toString, new String[]{"prepared-statement.cache.threshold", "preparedStatementCacheThreshold"});
        JDBCSettings.DESCRIPTION_CACHE_SIZE.init("jdbc", "Size of the query description cache.\n\nA value of zero disables the cache.", Integer.class, "250", str -> JDBCSettingsInit.checkRange("description.cache.size", Integer.parseInt(str), 0, null), Object::toString, new String[]{"description.cache.size", "descriptionCacheSize"});
        JDBCSettings.DEFAULT_NETWORK_TIMEOUT.init("jdbc", "Default timeout for network communication.\n\nValue can be changed at runtime through API.\n\nValue of zero disables the timeout.", Integer.class, "0", str -> JDBCSettingsInit.checkRange("network.timeout", Integer.parseInt(str), 0, null), Object::toString, new String[]{"network.timeout", "networkTimeout"});
        JDBCSettings.STRICT_MODE.init("jdbc", "Enable or disable strict adherence to JDBC specification.\n\nAffected behavior when disabled:\n<ul>\n  <li><code>ResultSetMetaData.getColumnName(int)</code> returns a value equivalent to <code>ResultSetMetaData.getColumnLabel(int)</code>, if a label is available.</li>\n  <li>The <code>Statement.executeBatch(...)</code> family of methods insert an extraneous EXECUTE_FAILED status into <code>BatchUpdateException.getUpdateCounts()</code> even though PostgreSQL stops executing at the first error.</li>\n</ul>\n", Boolean.class, "true", Boolean::parseBoolean, Object::toString, new String[]{"strict-mode", "strictMode"});
        JDBCSettings.DEFAULT_FETCH_SIZE.init("jdbc", "Default fetch size of query results.\n\n Value can be changed at runtime.\n\nA value of zero disables batching results.", Integer.class, (String)null, str -> JDBCSettingsInit.checkRange("fetch.size", Integer.parseInt(str), 0, null), Object::toString, new String[]{"fetch.size", "fetchSize"});
        JDBCSettings.HOUSEKEEPER.init("jdbc", "Enables or disables the housekeeping system for leaked JDBC objects.", Boolean.class, "true", Boolean::parseBoolean, Object::toString, new String[]{"housekeeper", "housekeeper.enabled"});
        JDBCSettings.REGISTRY_SHARING.init("jdbc", "Enables or disables sharing type registries between connections.", Boolean.class, "true", Boolean::parseBoolean, Object::toString, new String[]{"registry.sharing", "registrySharing"});
        JDBCSettings.API_TRACE.init("jdbc", "Enables or disables API trace output.\n\n", Boolean.class, "false", Boolean::parseBoolean, Object::toString, new String[]{"api.trace"});
        JDBCSettings.API_TRACE_FILE.init("jdbc", "File destination of API trace output.\n\nNOTE: `api.trace` must be `true` to generate trace output", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"api.trace.file"});
        JDBCSettings.CI_APPLICATION_NAME.init("jdbc-client-info", "The name of the application currently utilizing the connection", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"ApplicationName", "application_name"});
        JDBCSettings.CI_CLIENT_USER.init("jdbc-client-info", "The name of the user that the application using the connection is performing work for. This may not be the same as the user that was used in establishing the connection.", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"ClientUser", "session_authorization"});
    }

    public static Integer checkRange(String name, Integer value, Integer min, Integer max) {
        if (min != null && value < min) {
            throw new IllegalArgumentException("Setting '" + name + "' is below minimum value of " + min);
        }
        if (max != null && value > max) {
            throw new IllegalArgumentException("Setting '" + name + "' is above maximum value of " + max);
        }
        return value;
    }
}

