/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.BatchResults;
import com.impossibl.postgres.jdbc.ErrorUtils;
import java.sql.BatchUpdateException;
import java.util.Arrays;

class LongBatchResults
implements BatchResults {
    long[] counts = new long[0];
    boolean strict;

    LongBatchResults(boolean strict) {
        this.strict = strict;
    }

    @Override
    public void setBatchSize(int size) {
        this.counts = new long[size];
        Arrays.fill(this.counts, -2L);
    }

    @Override
    public void setUpdateCount(int batchIdx, long count) {
        this.counts[batchIdx] = count;
    }

    @Override
    public BatchUpdateException getException(int batchIdx, String message, Exception cause) {
        long[] counts;
        if (this.strict) {
            counts = Arrays.copyOf(this.counts, batchIdx);
        } else {
            counts = Arrays.copyOf(this.counts, batchIdx + 1);
            counts[batchIdx] = -3L;
        }
        return new BatchUpdateException(message, null, 0, counts, (Throwable)(cause != null ? ErrorUtils.makeSQLException(cause) : null));
    }
}

