/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.JDBCTypeMapping;
import com.impossibl.postgres.jdbc.PGStruct;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.CustomTypes;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;

public abstract class PGBuffersStruct<Buffer>
extends PGStruct {
    private Buffer[] attributeBuffers;

    private PGBuffersStruct(Context context, String typeName, Type[] attributeTypes, Buffer[] attributeBuffers) {
        super(context, typeName, attributeTypes);
        this.attributeBuffers = attributeBuffers;
    }

    protected abstract Object getAttribute(Context var1, Type var2, Buffer var3) throws IOException;

    @Override
    public Object[] getAttributes(Context context) throws IOException {
        Object[] attributeValues = new Object[this.attributeBuffers.length];
        for (int attributeIdx = 0; attributeIdx < attributeValues.length; ++attributeIdx) {
            Buffer attributeBuffer = this.attributeBuffers[attributeIdx];
            attributeValues[attributeIdx] = attributeBuffer == null ? null : this.getAttribute(context, this.attributeTypes[attributeIdx], attributeBuffer);
        }
        return attributeValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PGBuffersStruct struct = (PGBuffersStruct)o;
        return Objects.equals(this.context, struct.context) && Objects.equals(this.typeName, struct.typeName) && Arrays.equals(this.attributeTypes, struct.attributeTypes) && Arrays.equals(this.attributeBuffers, struct.attributeBuffers);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.typeName, this.attributeTypes, this.attributeBuffers);
    }

    public static class Text
    extends PGBuffersStruct<CharSequence> {
        public Text(Context context, String typeName, Type[] attributeTypes, CharSequence[] attributeBuffers) {
            super(context, typeName, attributeTypes, attributeBuffers);
        }

        @Override
        protected Object getAttribute(Context context, Type type, CharSequence buffer) throws IOException {
            Class<?> targetClass = CustomTypes.lookupCustomType(type, context.getCustomTypeMap(), null);
            return type.getTextCodec().getDecoder().decode(context, type, type.getLength(), null, buffer, targetClass, null);
        }
    }

    public static class Binary
    extends PGBuffersStruct<ByteBuf> {
        public static final ByteBufAllocator ALLOC = new UnpooledByteBufAllocator(false, true);

        public static Binary encode(Context context, CompositeType type, Object[] values) throws SQLException, IOException {
            Type[] attributeTypes = new Type[values.length];
            ByteBuf[] attributeBuffers = new ByteBuf[values.length];
            for (int attributeIdx = 0; attributeIdx < attributeBuffers.length; ++attributeIdx) {
                ByteBuf attributeBuffer = ALLOC.buffer();
                Object value = values[attributeIdx];
                if (value == null) {
                    attributeTypes[attributeIdx] = context.getRegistry().loadBaseType("text");
                    attributeBuffers[attributeIdx] = null;
                    continue;
                }
                Type attributeType = JDBCTypeMapping.getType(JDBCTypeMapping.getSQLType(value), value, context.getRegistry());
                if (attributeType == null) {
                    throw new IOException("Unable to determine type of attribute " + (attributeIdx + 1));
                }
                attributeType.getBinaryCodec().getEncoder().encode(context, type, values[attributeIdx], null, attributeBuffer);
                attributeTypes[attributeIdx] = attributeType;
                attributeBuffers[attributeIdx] = attributeBuffer;
            }
            return new Binary(context, type.getQualifiedName().toString(), attributeTypes, attributeBuffers);
        }

        public Binary(Context context, String typeName, Type[] attributeTypes, ByteBuf[] attributeBuffers) {
            super(context, typeName, attributeTypes, attributeBuffers);
        }

        @Override
        protected Object getAttribute(Context context, Type type, ByteBuf buffer) throws IOException {
            Class<?> targetClass = CustomTypes.lookupCustomType(type, context.getCustomTypeMap(), null);
            return type.getBinaryCodec().getDecoder().decode(context, type, type.getLength(), null, buffer, targetClass, null);
        }
    }
}

