/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class PGSQLInput<Buffer>
implements SQLInput {
    private Context context;
    private Type[] attributeTypes;
    private Buffer[] attributeBuffers;
    private int currentAttrIdx;
    private Boolean nullFlag;

    PGSQLInput(Context context, Type[] attributeTypes, Buffer[] attributeBuffers) {
        this.context = context;
        this.attributeTypes = attributeTypes;
        this.attributeBuffers = attributeBuffers;
        this.currentAttrIdx = -1;
    }

    protected abstract Type.Codec.Decoder<Buffer> getDecoder(Type var1);

    private <Result> Result getNextAttributeValue(Class<? extends Result> targetClass) throws SQLException {
        return targetClass.cast(this.getNextAttributeObject(targetClass));
    }

    private Object getNextAttributeObject(Class<?> targetClass) throws SQLException {
        ++this.currentAttrIdx;
        Type type = this.attributeTypes[this.currentAttrIdx];
        Buffer buffer = this.attributeBuffers[this.currentAttrIdx];
        if (buffer == null) {
            this.nullFlag = true;
            return null;
        }
        try {
            Object result = this.getDecoder(type).decode(this.context, type, type.getLength(), null, buffer, targetClass, null);
            this.nullFlag = result == null;
            return result;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String readString() throws SQLException {
        return this.getNextAttributeValue(String.class);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        Boolean val = this.getNextAttributeValue(Boolean.class);
        return val != null ? val : false;
    }

    @Override
    public byte readByte() throws SQLException {
        Byte val = this.getNextAttributeValue(Byte.class);
        return val != null ? val : (byte)0;
    }

    @Override
    public short readShort() throws SQLException {
        Short val = this.getNextAttributeValue(Short.class);
        return val != null ? val : (short)0;
    }

    @Override
    public int readInt() throws SQLException {
        Integer val = this.getNextAttributeValue(Integer.class);
        return val != null ? val : 0;
    }

    @Override
    public long readLong() throws SQLException {
        Long val = this.getNextAttributeValue(Long.class);
        return val != null ? val : 0L;
    }

    @Override
    public float readFloat() throws SQLException {
        Float val = this.getNextAttributeValue(Float.class);
        return val != null ? val.floatValue() : 0.0f;
    }

    @Override
    public double readDouble() throws SQLException {
        Double val = this.getNextAttributeValue(Double.class);
        return val != null ? val : 0.0;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return this.getNextAttributeValue(BigDecimal.class);
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return this.getNextAttributeValue(byte[].class);
    }

    @Override
    public Date readDate() throws SQLException {
        return this.getNextAttributeValue(Date.class);
    }

    @Override
    public Time readTime() throws SQLException {
        return this.getNextAttributeValue(Time.class);
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return this.getNextAttributeValue(Timestamp.class);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        return new StringReader(this.getNextAttributeValue(String.class));
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        return new ByteArrayInputStream(this.getNextAttributeValue(String.class).getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public Object readObject() throws SQLException {
        return this.getNextAttributeObject(null);
    }

    @Override
    public <T> T readObject(Class<T> type) throws SQLException {
        return this.getNextAttributeValue(type);
    }

    @Override
    public Ref readRef() throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public Blob readBlob() throws SQLException {
        return this.getNextAttributeValue(Blob.class);
    }

    @Override
    public Clob readClob() throws SQLException {
        return this.getNextAttributeValue(Clob.class);
    }

    @Override
    public Array readArray() throws SQLException {
        return this.getNextAttributeValue(Array.class);
    }

    @Override
    public URL readURL() throws SQLException {
        return this.getNextAttributeValue(URL.class);
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        return this.getNextAttributeValue(SQLXML.class);
    }

    @Override
    public RowId readRowId() throws SQLException {
        return this.getNextAttributeValue(RowId.class);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.nullFlag == null) {
            throw new SQLException("no value read");
        }
        return this.nullFlag;
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public String readNString() throws SQLException {
        throw Exceptions.NOT_SUPPORTED;
    }

    public static class Text
    extends PGSQLInput<CharSequence> {
        public Text(Context context, Type[] attributeTypes, CharSequence[] attributeBuffers) {
            super(context, attributeTypes, attributeBuffers);
        }

        @Override
        protected Type.Codec.Decoder<CharSequence> getDecoder(Type type) {
            return type.getTextCodec().getDecoder();
        }
    }

    public static class Binary
    extends PGSQLInput<ByteBuf> {
        public Binary(Context context, Type[] attributeTypes, ByteBuf[] attributeBuffers) {
            super(context, attributeTypes, attributeBuffers);
        }

        @Override
        protected Type.Codec.Decoder<ByteBuf> getDecoder(Type type) {
            return type.getBinaryCodec().getDecoder();
        }
    }
}

