/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.TypeMapContext;
import com.impossibl.postgres.types.Type;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

public abstract class PGStruct
implements Struct {
    protected Context context;
    protected String typeName;
    protected Type[] attributeTypes;

    PGStruct(Context context, String typeName, Type[] attributeTypes) {
        this.context = context;
        this.typeName = typeName;
        this.attributeTypes = attributeTypes;
    }

    public Type[] getAttributeTypes() {
        return this.attributeTypes;
    }

    @Override
    public String getSQLTypeName() {
        return this.typeName;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        try {
            return this.getAttributes(this.context);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> typeMap) throws SQLException {
        try {
            return this.getAttributes(new TypeMapContext(this.context, typeMap));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public abstract Object[] getAttributes(Context var1) throws IOException;
}

