/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.BlobInputStream;
import com.impossibl.postgres.jdbc.ClobReader;
import com.impossibl.postgres.jdbc.PGBlob;
import com.impossibl.postgres.jdbc.PGClob;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGRowId;
import com.impossibl.postgres.jdbc.PGSQLXML;
import com.impossibl.postgres.utils.guava.ByteStreams;
import com.impossibl.postgres.utils.guava.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;

class Unwrapping {
    Unwrapping() {
    }

    static Object unwrapObject(PGDirectConnection connection, Object x) throws SQLException {
        if (x instanceof Blob) {
            return Unwrapping.unwrapBlob(connection, (Blob)x);
        }
        if (x instanceof Clob) {
            return Unwrapping.unwrapClob(connection, (Clob)x);
        }
        if (x instanceof RowId) {
            return Unwrapping.unwrapRowId((RowId)x);
        }
        if (x instanceof SQLXML) {
            return Unwrapping.unwrapXML((SQLXML)x);
        }
        return x;
    }

    static PGSQLXML unwrapXML(SQLXML x) throws SQLException {
        if (x == null) {
            return null;
        }
        if (!(x instanceof PGSQLXML)) {
            throw new SQLException("SQLXML is from a different provider");
        }
        PGSQLXML xml = (PGSQLXML)x;
        if (xml.isNull()) {
            return null;
        }
        return xml;
    }

    static PGRowId unwrapRowId(RowId x) throws SQLException {
        if (x == null) {
            return null;
        }
        if (x instanceof PGRowId) {
            return (PGRowId)x;
        }
        throw new SQLException("RowId is from a different provider");
    }

    static PGBlob unwrapBlob(PGDirectConnection connection, Blob x) throws SQLException {
        if (x == null) {
            return null;
        }
        if (x instanceof PGBlob) {
            return (PGBlob)x;
        }
        InputStream in = x.getBinaryStream();
        if (in instanceof BlobInputStream) {
            return new PGBlob(connection, ((BlobInputStream)in).lo.oid);
        }
        PGBlob nx = (PGBlob)connection.createBlob();
        OutputStream out = nx.setBinaryStream(1L);
        try {
            ByteStreams.copy(in, out);
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return nx;
    }

    static PGClob unwrapClob(PGDirectConnection connection, Clob x) throws SQLException {
        if (x == null) {
            return null;
        }
        if (x instanceof PGClob) {
            return (PGClob)x;
        }
        Reader in = x.getCharacterStream();
        if (in instanceof ClobReader) {
            return new PGClob(connection, ((ClobReader)in).lo.oid);
        }
        PGClob nx = (PGClob)connection.createClob();
        Writer out = nx.setCharacterStream(1L);
        try {
            CharStreams.copy(in, out);
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return nx;
    }
}

