/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowDataSet;
import com.impossibl.postgres.system.Empty;
import com.impossibl.postgres.utils.Nulls;
import io.netty.util.AbstractReferenceCounted;
import java.util.Arrays;

public class ResultBatch
extends AbstractReferenceCounted
implements AutoCloseable {
    private String command;
    private Long rowsAffected;
    private Long insertedOid;
    private ResultField[] fields;
    private RowDataSet rows;

    public ResultBatch(String command, Long rowsAffected, Long insertedOid, ResultField[] fields, RowDataSet rows) {
        this.command = command;
        this.rowsAffected = rowsAffected;
        this.insertedOid = insertedOid;
        this.fields = Nulls.firstNonNull(fields, Empty.EMPTY_FIELDS);
        this.rows = rows;
    }

    public boolean hasRows() {
        return this.fields.length != 0;
    }

    public boolean isEmpty() {
        return !this.hasRows() || this.rows.isEmpty();
    }

    public String getCommand() {
        return this.command;
    }

    public boolean hasRowsAffected() {
        return this.rowsAffected != null;
    }

    public Long getRowsAffected() {
        if (!this.hasRowsAffected()) {
            return null;
        }
        return Nulls.firstNonNull(this.rowsAffected, 0L);
    }

    public Long getInsertedOid() {
        return this.insertedOid;
    }

    public ResultField[] getFields() {
        return this.fields;
    }

    public RowDataSet borrowRows() {
        return this.rows;
    }

    public RowDataSet takeRows() {
        RowDataSet rows = this.rows;
        this.rows = null;
        this.fields = Empty.EMPTY_FIELDS;
        return rows;
    }

    public void clearRowsAffected() {
        this.rowsAffected = null;
    }

    protected void deallocate() {
        if (this.rows != null) {
            this.rows.release();
        }
    }

    public ResultBatch touch(Object hint) {
        if (this.rows != null) {
            this.rows.touch(hint);
        }
        return this;
    }

    @Override
    public void close() {
        this.release();
    }

    public String toString() {
        return "ResultBatch{command='" + this.command + '\'' + ", rowsAffected=" + this.rowsAffected + ", insertedOid=" + this.insertedOid + ", fields=" + Arrays.toString(this.fields) + ", rows=" + (Object)((Object)this.rows) + '}';
    }
}

