/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.CopyFormat;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.RequestExecutor;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import com.impossibl.postgres.system.NoticeException;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class CopyOutRequest
implements ServerRequest {
    private String sql;
    private OutputStream stream;
    private RequestExecutor.CopyToHandler handler;
    private List<Notice> notices;

    CopyOutRequest(String sql, OutputStream stream, RequestExecutor.CopyToHandler handler) {
        this.sql = sql;
        this.stream = stream;
        this.handler = handler;
        this.notices = new ArrayList<Notice>();
    }

    @Override
    public ProtocolHandler createHandler() {
        return new Handler();
    }

    @Override
    public void execute(ProtocolChannel channel) throws IOException {
        channel.writeQuery(this.sql).flush();
    }

    private class Handler
    implements ProtocolHandler.CopyOutResponse,
    ProtocolHandler.CopyData,
    ProtocolHandler.CopyDone,
    ProtocolHandler.CopyFail,
    ProtocolHandler.RowDescription,
    ProtocolHandler.EmptyQuery,
    ProtocolHandler.CommandComplete,
    ProtocolHandler.CommandError,
    ProtocolHandler.ReportNotice,
    ProtocolHandler.ReadyForQuery {
        boolean started = false;

        private Handler() {
        }

        @Override
        public ProtocolHandler copyOut(CopyFormat format, FieldFormat[] columnFormats) {
            this.started = true;
            return this;
        }

        @Override
        public void copyData(ByteBuf data) throws IOException {
            data.readBytes(CopyOutRequest.this.stream, data.readableBytes());
        }

        @Override
        public void copyDone() {
        }

        @Override
        public void copyFail(String message) {
            CopyOutRequest.this.notices.add(new Notice("", "", message));
        }

        @Override
        public ProtocolHandler.Action rowDescription(ResultField[] fields) {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action emptyQuery() {
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action notice(Notice notice) {
            CopyOutRequest.this.notices.add(notice);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action commandComplete(String command, Long rowsAffected, Long insertedOid) throws IOException {
            if (!this.started) {
                CopyOutRequest.this.handler.handleError(new IOException("Command Not Initiated: COPY OUT"), CopyOutRequest.this.notices);
            } else {
                CopyOutRequest.this.handler.handleComplete();
            }
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action error(Notice notice) throws IOException {
            CopyOutRequest.this.handler.handleError(new NoticeException(notice), CopyOutRequest.this.notices);
            return ProtocolHandler.Action.Resume;
        }

        @Override
        public ProtocolHandler.Action readyForQuery(TransactionStatus txnStatus) throws IOException {
            CopyOutRequest.this.handler.handleReady(txnStatus);
            return ProtocolHandler.Action.Complete;
        }

        @Override
        public void exception(Throwable cause) throws IOException {
            CopyOutRequest.this.handler.handleError(cause, CopyOutRequest.this.notices);
        }
    }
}

