/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.v30.ProtocolChannel;
import com.impossibl.postgres.protocol.v30.ProtocolHandler;
import com.impossibl.postgres.protocol.v30.ServerRequest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class SSLQueryRequest
implements ServerRequest {
    private AtomicBoolean allowed = new AtomicBoolean(false);
    private CountDownLatch completed = new CountDownLatch(1);

    SSLQueryRequest() {
    }

    public boolean isAllowed() {
        return this.allowed.get();
    }

    boolean await(long timeout, TimeUnit timeoutUnits) throws InterruptedException {
        return this.completed.await(timeout, timeoutUnits);
    }

    @Override
    public ProtocolHandler createHandler() {
        return null;
    }

    @Override
    public void execute(final ProtocolChannel channel) throws IOException {
        channel.pipeline().addFirst("ssl-query", (ChannelHandler)new SimpleChannelInboundHandler<ByteBuf>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                try {
                    switch (msg.readByte()) {
                        case 83: {
                            SSLQueryRequest.this.allowed.set(true);
                            return;
                        }
                        case 78: {
                            SSLQueryRequest.this.allowed.set(false);
                            return;
                        }
                        default: {
                            throw new IOException("invalid SSL response");
                        }
                    }
                }
                finally {
                    channel.pipeline().remove("ssl-query");
                    SSLQueryRequest.this.completed.countDown();
                }
            }
        });
        channel.writeSSLRequest().flush();
    }
}

