/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system;

import com.impossibl.postgres.jdbc.PGDriver;
import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.ssl.SSLMode;
import com.impossibl.postgres.system.Setting;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.utils.StringTransforms;
import java.nio.charset.Charset;
import java.util.function.Function;

interface SystemSettingsInit {
    public static void init() {
        SystemSettings.SYS.init("system", "System Settings", true);
        SystemSettings.PROTO.init("protocol", "Protocol Settings", true);
        SystemSettings.SERVER.init("server", "Server reported settings", false);
        SystemSettings.DATABASE_URL.init("system", "URL of database connection", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"database.url", "url"});
        SystemSettings.DATABASE_NAME.init("system", "Name of database related to connection", String.class, "", Setting.Converter.identity(), Function.identity(), new String[]{"database.name", "database"});
        SystemSettings.APPLICATION_NAME.init("system", "Name of the client application", String.class, PGDriver.NAME, Setting.Converter.identity(), Function.identity(), new String[]{"application.name", "application_name"});
        SystemSettings.CREDENTIALS_USERNAME.init("system", "Username for server authentication & authorization.\n\nIf no value is provided is defaults to the Java system property `user.name`.", String.class, () -> System.getProperty("user.name", ""), Setting.Converter.identity(), Function.identity(), new String[]{"user"});
        SystemSettings.CREDENTIALS_PASSWORD.init("system", "Password for server authentication.", String.class, "", Setting.Converter.identity(), Function.identity(), new String[]{"password"});
        SystemSettings.FIELD_FORMAT_PREF.init("system", "Preferred format of result fields.", FieldFormat.class, "binary", str -> Enum.valueOf(FieldFormat.class, StringTransforms.toUpperCamelCase(str)), e -> StringTransforms.dashedFromCamelCase(e.name()), new String[]{"field.format"});
        SystemSettings.FIELD_LENGTH_MAX.init("system", "Default maximum allowed length of field.", Integer.class, (String)null, str -> SystemSettingsInit.checkRange("field.length.max", Integer.parseInt(str), 0, null), Object::toString, new String[]{"field.length.max"});
        SystemSettings.PARAM_FORMAT_PREF.init("system", "Preferred format of prepared statement parameters.", FieldFormat.class, "binary", str -> Enum.valueOf(FieldFormat.class, StringTransforms.toUpperCamelCase(str)), e -> StringTransforms.dashedFromCamelCase(e.name()), new String[]{"param.format"});
        SystemSettings.MONEY_FRACTIONAL_DIGITS.init("system", "# of fractional digits for money fields.", Integer.class, "2", str -> SystemSettingsInit.checkRange("money.fractional-digits", Integer.parseInt(str), 0, 20), Object::toString, new String[]{"money.fractional-digits", "field.money.fractionalDigits"});
        SystemSettings.SSL_MODE.init("system", "SSL connection mode.", SSLMode.class, "disable", str -> Enum.valueOf(SSLMode.class, StringTransforms.toUpperCamelCase(str)), e -> StringTransforms.dashedFromCamelCase(e.name()), new String[]{"ssl.mode", "sslMode"});
        SystemSettings.SSL_CRT_FILE.init("system", "SSL client certificate file name.", String.class, "postgresql.crt", Setting.Converter.identity(), Function.identity(), new String[]{"ssl.certificate.file", "sslCertificateFile"});
        SystemSettings.SSL_CA_CRT_FILE.init("system", "SSL certificate authority file name.", String.class, "root.crt", Setting.Converter.identity(), Function.identity(), new String[]{"ssl.ca.certificate.file", "sslRootCertificateFile"});
        SystemSettings.SSL_KEY_FILE.init("system", "SSL key file name.", String.class, "postgresql.pk8", Setting.Converter.identity(), Function.identity(), new String[]{"ssl.key.file", "sslKeyFile"});
        SystemSettings.SSL_KEY_PASSWORD.init("system", "SSL key file password.", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"ssl.key.password", "sslPassword"});
        SystemSettings.SSL_KEY_PASSWORD_CALLBACK.init("system", "SSL key file password callback class name.", Class.class, "com.impossibl.postgres.protocol.ssl.ConsolePasswordCallbackHandler", Class::forName, Class::getName, new String[]{"ssl.key.password.callback", "sslPasswordCallback"});
        SystemSettings.SSL_HOME_DIR.init("system", "Directory that SSL files are located in.\n\nIf the value begins with a path separator (e.g. `/`) it will be considered an absolute path. In all other \ncases it is considered a value relative to the user's home directory.\nOn Windows `$APPDATA` is used as the \nhome directory, all others use the `user.home` system property.", String.class, ".postgresql", Setting.Converter.identity(), Function.identity(), new String[]{"ssl.home-dir"});
        SystemSettings.SQL_TRACE.init("system", "Enables or disables SQL trace output", Boolean.class, "false", Boolean::parseBoolean, Object::toString, new String[]{"sql.trace"});
        SystemSettings.SQL_TRACE_FILE.init("system", "File destination of SQL trace output.\n\nNOTE: `sql.trace` must be `true` to generate trace output", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"sql.trace.file"});
        SystemSettings.PROTOCOL_VERSION.init("protocol", "Version of server protocol to use.\n\nValid protocol versions:\n<ul>\n  <li><code>3.0</code></li>\n</ul>\n", Version.class, "3.0", Version::parse, Version::toString, new String[]{"protocol.version"});
        SystemSettings.PROTOCOL_IO_MODE.init("protocol", "I/O subsystem selection mode.", SystemSettings.ProtocolIOMode.class, "any", str -> Enum.valueOf(SystemSettings.ProtocolIOMode.class, StringTransforms.toUpperSnakeCase(str)), e -> StringTransforms.dashedFromSnakeCase(e.name()), new String[]{"protocol.io.mode"});
        SystemSettings.PROTOCOL_IO_THREADS.init("protocol", "Number of I/O threads in pool", Integer.class, "3", str -> SystemSettingsInit.checkRange("protocol.io.threads", Integer.parseInt(str), 1, null), Object::toString, new String[]{"protocol.io.threads"});
        SystemSettings.PROTOCOL_ENCODING.init("protocol", "Text encoding", Charset.class, "UTF-8", Charset::forName, Charset::name, new String[]{"protocol.encoding", "clientEncoding", "client_encoding"});
        SystemSettings.PROTOCOL_SOCKET_RECV_BUFFER_SIZE.init("protocol", "Socket receive buffer size", Integer.class, (String)null, str -> SystemSettingsInit.checkRange("protocol.socket.recv-buffer.size", Integer.parseInt(str), 0, null), Object::toString, new String[]{"protocol.socket.recv-buffer.size", "receiveBufferSize"});
        SystemSettings.PROTOCOL_SOCKET_SEND_BUFFER_SIZE.init("protocol", "Socket send buffer size", Integer.class, (String)null, str -> SystemSettingsInit.checkRange("protocol.socket.send-buffer.size", Integer.parseInt(str), 0, null), Object::toString, new String[]{"protocol.socket.send-buffer.size", "sendBufferSize"});
        SystemSettings.PROTOCOL_BUFFER_POOLING.init("protocol", "Enable or disable pooling of byte buffers", Boolean.class, "true", Boolean::parseBoolean, Object::toString, new String[]{"protocol.buffer.pooling"});
        SystemSettings.PROTOCOL_MESSAGE_SIZE_MAX.init("protocol", "Maximum size message that can be received", Integer.class, "20971520", str -> SystemSettingsInit.checkRange("protocol.message.size.max", Integer.parseInt(str), 0, null), Object::toString, new String[]{"protocol.message.size.max"});
        SystemSettings.PROTOCOL_TRACE.init("protocol", "Enable or disable message trace output", Boolean.class, "false", Boolean::parseBoolean, Object::toString, new String[]{"protocol.trace"});
        SystemSettings.PROTOCOL_TRACE_FILE.init("protocol", "File destination of message trace output\n\nNOTE: `protocol.trace` must be `true` to generate trace output", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"protocol.trace.file"});
        SystemSettings.SESSION_USER.init("server", "Session username", String.class, (String)null, Setting.Converter.identity(), Function.identity(), new String[]{"session_authorization"});
        SystemSettings.STANDARD_CONFORMING_STRINGS.init("server", "Use SQL standard conforming strings", Boolean.class, (String)null, Boolean::parseBoolean, Object::toString, new String[]{"standard_conforming_strings"});
    }

    public static Integer checkRange(String name, Integer value, Integer min, Integer max) {
        if (min != null && value < min) {
            throw new IllegalArgumentException("Setting '" + name + "' is below minimum value of " + min);
        }
        if (max != null && value > max) {
            throw new IllegalArgumentException("Setting '" + name + "' is above maximum value of " + max);
        }
        return value;
    }
}

