/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system;

import com.impossibl.postgres.utils.guava.Strings;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)(?:\\.(\\d+)(?:\\.(\\d+))?)?(\\s*[a-zA-Z0-9-]+)?(\\s+.*)?");
    private static final HashMap<Version, Version> all = new HashMap();
    private int major;
    private Integer minor;
    private Integer revision;
    private String tag;

    public static Version parse(String versionString) {
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version string: " + versionString);
        }
        int major = Integer.parseInt(matcher.group(1));
        Integer minor = !Strings.isNullOrEmpty(matcher.group(2)) ? Integer.valueOf(Integer.parseInt(matcher.group(2))) : null;
        Integer revision = !Strings.isNullOrEmpty(matcher.group(3)) ? Integer.valueOf(Integer.parseInt(matcher.group(3))) : null;
        String tag = !Strings.isNullOrEmpty(matcher.group(4)) ? matcher.group(4) : null;
        return Version.get(major, minor, revision, tag);
    }

    public static synchronized Version get(int major, Integer minor, Integer revision) {
        return Version.get(major, minor, revision, null);
    }

    public static synchronized Version get(int major, Integer minor, Integer revision, String tag) {
        Version test = new Version(major, minor, revision, tag);
        Version found = all.get(test);
        if (found == null) {
            all.put(test, test);
            found = test;
        }
        return found;
    }

    private Version(int major, Integer minor, Integer revision, String tag) {
        if (minor == null && revision != null) {
            throw new IllegalArgumentException("revision cannot have value when minor does not");
        }
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.tag = tag;
    }

    public int getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public int getMinorValue() {
        return this.minor != null ? this.minor : 0;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public int getRevisionValue() {
        return this.revision != null ? this.revision : 0;
    }

    public String getTag() {
        return this.tag != null ? this.tag.trim() : null;
    }

    public boolean isMinimum(int major) {
        return this.major >= major;
    }

    public boolean isMinimum(int major, int minor) {
        if (this.major < major) {
            return false;
        }
        if (this.major > major) {
            return true;
        }
        return this.getMinorValue() >= minor;
    }

    public boolean isMinimum(int major, int minor, int revision) {
        if (this.major < major) {
            return false;
        }
        if (this.major > major) {
            return true;
        }
        if (this.minor < minor) {
            return false;
        }
        if (this.minor > minor) {
            return true;
        }
        return this.getRevisionValue() >= revision;
    }

    public boolean isMinimum(Version ver) {
        return this.isMinimum(ver.getMajor(), ver.getMinorValue(), ver.getRevisionValue());
    }

    public boolean isEqual(int major) {
        return major == this.major;
    }

    public boolean isEqual(int major, int minor) {
        return major == this.major && this.getMinorValue() == minor;
    }

    public boolean isEqual(int major, int minor, int revision) {
        return major == this.major && this.getMinorValue() == minor && this.getRevisionValue() == revision;
    }

    public boolean isEqual(Version ver) {
        return this.isEqual(ver.getMajor(), ver.getMinorValue(), ver.getRevisionValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        if (this.minor != null) {
            sb.append('.').append(this.minor);
            if (this.revision != null) {
                sb.append('.').append(this.revision);
            }
        }
        if (this.tag != null) {
            sb.append(this.tag);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && Objects.equals(this.minor, version.minor) && Objects.equals(this.revision, version.revision) && Objects.equals(this.tag, version.tag);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.revision, this.tag);
    }
}

