/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.AutoConvertingEncoder;
import com.impossibl.postgres.system.procs.BaseTextEncoder;
import com.impossibl.postgres.types.Type;
import java.io.IOException;

abstract class AutoConvertingTextEncoder<N>
extends BaseTextEncoder
implements AutoConvertingEncoder {
    private AutoConvertingEncoder.Converter<N> converter;

    protected AutoConvertingTextEncoder(AutoConvertingEncoder.StringConverter<N> converter) {
        this(new AutoConvertingEncoder.FromStringConverter<N>(converter));
    }

    protected AutoConvertingTextEncoder(AutoConvertingEncoder.Converter<N> converter) {
        this.converter = converter;
    }

    protected N convertInput(Context context, Type type, Object source, Object sourceContext) throws ConversionException {
        N res;
        if (this.converter != null && (res = this.converter.convert(context, source, sourceContext)) != null) {
            return res;
        }
        if (this.getDefaultClass().isInstance(source)) {
            return this.getDefaultClass().cast(source);
        }
        throw new ConversionException(source.getClass(), type);
    }

    @Override
    protected void encodeValue(Context context, Type type, Object value, Object sourceContext, StringBuilder buffer) throws IOException {
        N convertedValue = this.convertInput(context, type, value, sourceContext);
        if (convertedValue == null) {
            throw new IOException("Error coercing value");
        }
        this.encodeNativeValue(context, type, convertedValue, sourceContext, buffer);
    }

    protected abstract Class<N> getDefaultClass();

    protected abstract void encodeNativeValue(Context var1, Type var2, N var3, Object var4, StringBuilder var5) throws IOException;
}

