/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Interval;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryEncoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;

public class Intervals
extends SimpleProcProvider {
    public Intervals() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "interval_");
    }

    static class TxtEncoder
    extends AutoConvertingTextEncoder<Interval> {
        TxtEncoder() {
            super(Interval::parse);
        }

        @Override
        public Class<Interval> getDefaultClass() {
            return Interval.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Interval value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(context.getServerIntervalFormat().getPrinter().format(value));
        }
    }

    static class TxtDecoder
    extends AutoConvertingTextDecoder<Interval> {
        TxtDecoder() {
            super(Interval::toString);
        }

        @Override
        public Class<Interval> getDefaultClass() {
            return Interval.class;
        }

        @Override
        protected Interval decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return context.getServerIntervalFormat().getParser().parse(buffer);
        }
    }

    static class BinEncoder
    extends AutoConvertingBinaryEncoder<Interval> {
        BinEncoder() {
            super((Integer)16, Interval::parse);
        }

        @Override
        public Class<Interval> getDefaultClass() {
            return Interval.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Interval value, Object sourceContext, ByteBuf buffer) throws IOException {
            Duration duration = value.getDuration();
            buffer.writeLong(duration.getSeconds() * 1000000L + (long)(duration.getNano() / 1000));
            Period period = value.getPeriod();
            buffer.writeInt(period.getDays());
            buffer.writeInt(period.getYears() * 12 + period.getMonths());
        }
    }

    static class BinDecoder
    extends AutoConvertingBinaryDecoder<Interval> {
        BinDecoder() {
            super((Integer)16, Interval::toString);
        }

        @Override
        public Class<Interval> getDefaultClass() {
            return Interval.class;
        }

        @Override
        protected Interval decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            long timeMicros = buffer.readLong();
            int days = buffer.readInt();
            int months = buffer.readInt();
            Period period = Period.of(0, months, days);
            Duration duration = Duration.of(timeMicros, ChronoUnit.MICROS);
            return Interval.of(period, duration);
        }
    }
}

