/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryEncoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextEncoder;
import com.impossibl.postgres.system.procs.NumericDecodingConverter;
import com.impossibl.postgres.system.procs.NumericEncodingConverter;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;

public class Moneys
extends SimpleProcProvider {
    public Moneys() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "cash_");
    }

    private static BigDecimal convertStringInput(Context context, String value) throws ConversionException {
        try {
            return (BigDecimal)context.getClientDecimalFormatter().parse(value);
        }
        catch (ParseException e) {
            throw new ConversionException("Invalid Long", e);
        }
    }

    private static String convertStringOutput(Context context, Number number) {
        return context.getClientDecimalFormatter().format(number);
    }

    static class TxtEncoder
    extends AutoConvertingTextEncoder<BigDecimal> {
        protected TxtEncoder() {
            super(new NumericEncodingConverter<BigDecimal>((x$0, x$1) -> Moneys.convertStringInput(x$0, x$1), val -> val != false ? BigDecimal.ONE : BigDecimal.ZERO, val -> BigDecimal.valueOf(val.doubleValue())));
        }

        @Override
        public Class<BigDecimal> getDefaultClass() {
            return BigDecimal.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, BigDecimal value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(context.getServerCurrencyFormatter().format(value));
        }
    }

    static class TxtDecoder
    extends AutoConvertingTextDecoder<BigDecimal> {
        TxtDecoder() {
            super(new NumericDecodingConverter<BigDecimal>((x$0, x$1) -> Moneys.convertStringOutput(x$0, x$1)));
        }

        @Override
        public Class<BigDecimal> getDefaultClass() {
            return BigDecimal.class;
        }

        @Override
        protected BigDecimal decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException {
            try {
                return (BigDecimal)context.getServerCurrencyFormatter().parse(buffer.toString());
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
    }

    static class BinEncoder
    extends AutoConvertingBinaryEncoder<BigDecimal> {
        BinEncoder() {
            super((Integer)8, new NumericEncodingConverter<BigDecimal>((x$0, x$1) -> Moneys.convertStringInput(x$0, x$1), val -> val != false ? BigDecimal.ONE : BigDecimal.ZERO, val -> BigDecimal.valueOf(val.doubleValue())));
        }

        @Override
        public Class<BigDecimal> getDefaultClass() {
            return BigDecimal.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, BigDecimal value, Object sourceContext, ByteBuf buffer) throws IOException {
            int fracDigits = context.getSetting(SystemSettings.MONEY_FRACTIONAL_DIGITS);
            value = value.setScale(fracDigits, RoundingMode.HALF_UP);
            buffer.writeLong(value.unscaledValue().longValue());
        }
    }

    static class BinDecoder
    extends AutoConvertingBinaryDecoder<BigDecimal> {
        BinDecoder() {
            super(8);
        }

        @Override
        public Class<BigDecimal> getDefaultClass() {
            return BigDecimal.class;
        }

        @Override
        protected BigDecimal decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            long val = buffer.readLong();
            int fracDigits = context.getSetting(SystemSettings.MONEY_FRACTIONAL_DIGITS);
            return new BigDecimal(BigInteger.valueOf(val), fracDigits);
        }
    }
}

