/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.ConversionException;
import com.impossibl.postgres.system.procs.NumericBinaryDecoder;
import com.impossibl.postgres.system.procs.NumericBinaryEncoder;
import com.impossibl.postgres.system.procs.NumericTextDecoder;
import com.impossibl.postgres.system.procs.NumericTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class Numerics
extends SimpleProcProvider {
    private static final short NUMERIC_POS = 0;
    private static final short NUMERIC_NEG = 16384;
    private static final short DEC_DIGITS = 4;

    public Numerics() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "numeric_");
    }

    private static Number convertStringInput(Context context, String value) throws ConversionException {
        if (value.equalsIgnoreCase("NaN")) {
            return Double.NaN;
        }
        if (value.equalsIgnoreCase("infinity") || value.equalsIgnoreCase("+infinity")) {
            return Double.POSITIVE_INFINITY;
        }
        if (value.equalsIgnoreCase("-infinity")) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            return context.getClientDecimalFormatter().parse(value);
        }
        catch (ParseException e) {
            throw new ConversionException("Invalid Numeric Value", e);
        }
    }

    private static BigDecimal convertBoolInput(Boolean value) {
        return value != false ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    private static Number convertInput(Number source) throws ConversionException {
        if (source instanceof BigDecimal) {
            return source;
        }
        if (source instanceof BigInteger) {
            return new BigDecimal(source.toString());
        }
        if (source instanceof Byte || source instanceof Short || source instanceof Integer || source instanceof Long) {
            return BigDecimal.valueOf(source.longValue());
        }
        if (source instanceof AtomicInteger) {
            return new BigDecimal(((AtomicInteger)source).get());
        }
        if (source instanceof AtomicLong) {
            return new BigDecimal(((AtomicLong)source).get());
        }
        if (source instanceof Float) {
            Float source1 = (Float)source;
            if (source1.isNaN()) {
                return source1.doubleValue();
            }
            if (source1.isInfinite()) {
                throw new ConversionException("Numeric types cannot represent +/- infinity");
            }
            return BigDecimal.valueOf(source1.floatValue());
        }
        if (source instanceof Double) {
            Double source1 = (Double)source;
            if (source1.isNaN()) {
                return source1;
            }
            if (source1.isInfinite()) {
                throw new ConversionException("Numeric types cannot represent +/- infinity");
            }
            return BigDecimal.valueOf(source1);
        }
        return null;
    }

    private static String convertStringOutput(Context context, Number value) {
        return context.getClientDecimalFormatter().format(value);
    }

    private static short[] encodeFromString(String num, short[] info) {
        int ch;
        char[] numChars = num.toCharArray();
        byte[] numDigs = new byte[numChars.length - 1 + 8];
        int digs = 4;
        boolean haveDP = false;
        for (ch = 0; ch < numChars.length && numChars[ch] == '0'; ++ch) {
        }
        int sign = 0;
        int displayWeight = -1;
        int displayScale = 0;
        if (ch < numChars.length && numChars[ch] == '-') {
            sign = 16384;
            ++ch;
        }
        while (ch < numChars.length) {
            if (numChars[ch] == '.') {
                haveDP = true;
                ++ch;
                continue;
            }
            numDigs[digs++] = (byte)(numChars[ch++] - 48);
            if (!haveDP) {
                displayWeight = (short)(displayWeight + 1);
                continue;
            }
            displayScale = (short)(displayScale + 1);
        }
        short weight = displayWeight >= 0 ? (short)((displayWeight + 1 + 4 - 1) / 4 - 1) : (short)(-((-displayWeight - 1) / 4 + 1));
        int offset = (weight + 1) * 4 - (displayWeight + 1);
        int digitCount = ((digs -= 4) + offset + 4 - 1) / 4;
        int i = 4 - offset;
        short[] digits = new short[digitCount];
        int d = 0;
        while (digitCount-- > 0) {
            digits[d++] = (short)(((numDigs[i] * 10 + numDigs[i + 1]) * 10 + numDigs[i + 2]) * 10 + numDigs[i + 3]);
            i += 4;
        }
        info[0] = weight;
        info[1] = sign;
        info[2] = displayScale;
        return digits;
    }

    private static String decodeToString(short weight, short sign, short displayScale, short[] digits) {
        int d;
        StringBuilder sb = new StringBuilder();
        if (sign == 16384) {
            sb.append('-');
        }
        if (weight < 0) {
            d = weight + 1;
            sb.append(0);
        } else {
            for (d = 0; d <= weight; ++d) {
                short dig = d < digits.length ? digits[d] : (short)0;
                boolean putIt = d > 0;
                for (int b = 1000; b > 1; b /= 10) {
                    short d1 = (short)(dig / b);
                    dig = (short)(dig - d1 * b);
                    if (!(putIt |= d1 > 0)) continue;
                    sb.append((char)(d1 + 48));
                }
                sb.append((char)(dig + 48));
            }
        }
        if (displayScale > 0) {
            sb.append('.');
            int length = sb.length() + displayScale;
            for (int i = 0; i < displayScale; i += 4) {
                short dig = d >= 0 && d < digits.length ? digits[d] : (short)0;
                for (int b = 1000; b > 1 && sb.length() < length; b /= 10) {
                    short d1 = (short)(dig / b);
                    dig = (short)(dig - d1 * b);
                    sb.append((char)(d1 + 48));
                }
                if (sb.length() < length) {
                    sb.append((char)(dig + 48));
                }
                ++d;
            }
        }
        return sb.toString();
    }

    static class TxtEncoder
    extends NumericTextEncoder<Number> {
        TxtEncoder() {
            super((x$0, x$1) -> Numerics.convertStringInput(x$0, x$1), x$0 -> Numerics.convertBoolInput(x$0), x$0 -> Numerics.convertInput(x$0));
        }

        @Override
        public Class<Number> getDefaultClass() {
            return Number.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Number value, Object sourceContext, StringBuilder buffer) throws IOException {
            buffer.append(value);
        }
    }

    static class TxtDecoder
    extends NumericTextDecoder<Number> {
        protected TxtDecoder() {
            super((Context x$0, N x$1) -> Numerics.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Number> getDefaultClass() {
            return Number.class;
        }

        @Override
        protected Number decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return new BigDecimal(buffer.toString());
        }
    }

    static class BinEncoder
    extends NumericBinaryEncoder<Number> {
        BinEncoder() {
            super(null, (x$0, x$1) -> Numerics.convertStringInput(x$0, x$1), x$0 -> Numerics.convertBoolInput(x$0), x$0 -> Numerics.convertInput(x$0));
        }

        @Override
        public Class<Number> getDefaultClass() {
            return Number.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Number value, Object sourceContext, ByteBuf buffer) throws IOException {
            if (Double.isNaN(value.doubleValue())) {
                buffer.writeShort(0);
                buffer.writeShort(0);
                buffer.writeShort(-16384);
                buffer.writeShort(0);
                return;
            }
            BigDecimal decimal = (BigDecimal)value;
            if (sourceContext != null) {
                int scale = ((Number)sourceContext).intValue();
                decimal = decimal.setScale(scale, RoundingMode.HALF_UP);
            }
            String num = decimal.toPlainString();
            short[] info = new short[3];
            short[] digits = Numerics.encodeFromString(num, info);
            buffer.writeShort(digits.length);
            buffer.writeShort((int)info[0]);
            buffer.writeShort((int)info[1]);
            buffer.writeShort((int)info[2]);
            for (short digit : digits) {
                buffer.writeShort((int)digit);
            }
        }
    }

    static class BinDecoder
    extends NumericBinaryDecoder<Number> {
        BinDecoder() {
            super(null, (Context x$0, N x$1) -> Numerics.convertStringOutput(x$0, x$1));
        }

        @Override
        public Class<Number> getDefaultClass() {
            return Number.class;
        }

        @Override
        protected Number decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            int length = buffer.readableBytes();
            int readStart = buffer.readerIndex();
            short digitCount = buffer.readShort();
            short[] info = new short[]{buffer.readShort(), buffer.readShort(), buffer.readShort()};
            if (info[0] == 0 && info[1] == -16384 && info[2] == 0) {
                return Double.NaN;
            }
            short[] digits = new short[digitCount];
            for (int d = 0; d < digits.length; ++d) {
                digits[d] = buffer.readShort();
            }
            String num = Numerics.decodeToString(info[0], info[1], info[2], digits);
            if (length != buffer.readerIndex() - readStart) {
                throw new IOException("invalid length");
            }
            return new BigDecimal(num);
        }
    }
}

