/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.Tid;
import com.impossibl.postgres.jdbc.PGRowId;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingBinaryEncoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextDecoder;
import com.impossibl.postgres.system.procs.AutoConvertingTextEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.sql.RowId;
import java.text.ParseException;

public class Tids
extends SimpleProcProvider {
    public Tids() {
        super((Type.Codec.Encoder<StringBuilder>)new TxtEncoder(), (Type.Codec.Decoder<CharSequence>)new TxtDecoder(), (Type.Codec.Encoder<ByteBuf>)new BinEncoder(), (Type.Codec.Decoder<ByteBuf>)new BinDecoder(), "tid");
    }

    static Tid convertInput(Context context, Object source, Object sourceContext) {
        if (source instanceof Tid) {
            return (Tid)source;
        }
        if (source instanceof PGRowId) {
            return ((PGRowId)source).getTid();
        }
        if (source instanceof String) {
            Tids.parseTid((String)source);
        }
        return null;
    }

    static Object convertOutput(Context context, Tid decoded, Class<?> targetClass, Object targetContext) {
        if (targetClass == Tid.class) {
            return decoded;
        }
        if (targetClass == RowId.class) {
            return new PGRowId(decoded);
        }
        if (targetClass == String.class) {
            return "(" + decoded.getBlock() + "," + decoded.getOffset() + ")";
        }
        return null;
    }

    private static Tid parseTid(CharSequence source) {
        String[] items = source.subSequence(1, source.length() - 1).toString().split(",");
        int block = Integer.parseInt(items[0]);
        short offset = Short.parseShort(items[1]);
        return new Tid(block, offset);
    }

    private static void formatTid(Tid tid, StringBuilder out) {
        out.append('(').append(tid.getBlock()).append(',').append(tid.getOffset()).append(')');
    }

    static class TxtEncoder
    extends AutoConvertingTextEncoder<Tid> {
        TxtEncoder() {
            super(Tids::convertInput);
        }

        @Override
        protected Class<Tid> getDefaultClass() {
            return Tid.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Tid value, Object sourceContext, StringBuilder buffer) throws IOException {
            Tids.formatTid(value, buffer);
        }
    }

    static class TxtDecoder
    extends AutoConvertingTextDecoder<Tid> {
        TxtDecoder() {
            super(Tids::convertOutput);
        }

        @Override
        public Class<Tid> getDefaultClass() {
            return Tid.class;
        }

        @Override
        protected Tid decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Class<?> targetClass, Object targetContext) throws IOException, ParseException {
            return Tids.parseTid(buffer);
        }
    }

    static class BinEncoder
    extends AutoConvertingBinaryEncoder<Tid> {
        BinEncoder() {
            super((Integer)6, Tids::convertInput);
        }

        @Override
        protected Class<Tid> getDefaultClass() {
            return Tid.class;
        }

        @Override
        protected void encodeNativeValue(Context context, Type type, Tid value, Object sourceContext, ByteBuf buffer) throws IOException {
            buffer.writeInt(value.getBlock());
            buffer.writeShort((int)value.getOffset());
        }
    }

    static class BinDecoder
    extends AutoConvertingBinaryDecoder<Tid> {
        BinDecoder() {
            super((Integer)6, Tids::convertOutput);
        }

        @Override
        public Class<Tid> getDefaultClass() {
            return Tid.class;
        }

        @Override
        protected Tid decodeNativeValue(Context context, Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Class<?> targetClass, Object targetContext) throws IOException {
            int block = buffer.readInt();
            short offset = buffer.readShort();
            return new Tid(block, offset);
        }
    }
}

