/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class CacheMap<K, V>
extends LinkedHashMap<K, V> {
    private int maxSize;
    private Consumer<Map.Entry<K, V>> evictionHandler;

    public CacheMap(int maxSize, float loadFactor, boolean accessOrder) {
        super(maxSize + 1, loadFactor, accessOrder);
        this.maxSize = maxSize;
    }

    public CacheMap(int maxSize, float loadFactor, boolean accessOrder, Consumer<Map.Entry<K, V>> evictionHandler) {
        super(maxSize + 1, loadFactor, accessOrder);
        this.maxSize = maxSize;
        this.evictionHandler = evictionHandler;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.maxSize) {
            if (this.evictionHandler != null) {
                this.evictionHandler.accept(eldest);
            }
            return true;
        }
        return false;
    }
}

