/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.utils;

import java.io.Serializable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeLiteral<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Type actualType;

    protected TypeLiteral() {
    }

    public final Type getType() {
        if (this.actualType == null) {
            Class<?> typeLiteralSubclass = TypeLiteral.getTypeLiteralSubclass(this.getClass());
            if (typeLiteralSubclass == null) {
                throw new RuntimeException(this.getClass() + " is not a subclass of TypeLiteral");
            }
            this.actualType = TypeLiteral.getTypeParameter(typeLiteralSubclass);
            if (this.actualType == null) {
                throw new RuntimeException(this.getClass() + " does not specify the type parameter T of TypeLiteral<T>");
            }
        }
        return this.actualType;
    }

    public final Class<T> getRawType() {
        Type type = this.getType();
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return Object[].class;
        }
        throw new RuntimeException("Illegal type");
    }

    private static Class<?> getTypeLiteralSubclass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass.equals(TypeLiteral.class)) {
            return clazz;
        }
        if (superclass.equals(Object.class)) {
            return null;
        }
        return TypeLiteral.getTypeLiteralSubclass(superclass);
    }

    private static Type getTypeParameter(Class<?> superclass) {
        ParameterizedType parameterizedType;
        Type type = superclass.getGenericSuperclass();
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getActualTypeArguments().length == 1) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeLiteral) {
            TypeLiteral that = (TypeLiteral)obj;
            return this.getType().equals(that.getType());
        }
        return false;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        return this.getType().toString();
    }
}

