/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.adapter.impl;

import com.inspiresoftware.lib.dto.geda.adapter.ExtensibleBeanFactory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderBeanFactory
implements ExtensibleBeanFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderBeanFactory.class);
    private final Map<String, String> mappingClasses = new ConcurrentHashMap<String, String>();
    private final Map<String, String> mappingReps = new ConcurrentHashMap<String, String>();
    private final Map<String, Class> cacheClasses = new ConcurrentHashMap<String, Class>();
    private final Map<String, Class> cacheReps = new ConcurrentHashMap<String, Class>();
    private final Reference<ClassLoader> classLoader;

    public ClassLoaderBeanFactory(ClassLoader classLoader) {
        this.classLoader = new SoftReference<ClassLoader>(classLoader);
    }

    public ClassLoaderBeanFactory(ClassLoader classLoader, Map<String, String> mappingClasses, Map<String, String> mappingEntityRepresentatives) {
        this(classLoader);
        this.mappingClasses.putAll(mappingClasses);
        this.mappingReps.putAll(mappingClasses);
        this.mappingReps.putAll(mappingEntityRepresentatives);
    }

    @Override
    public void registerDto(String key, String className) throws IllegalArgumentException {
        if (key != null && key.length() > 0 && className != null && className.length() > 0) {
            if (this.mappingClasses.containsKey(key)) {
                throw new IllegalArgumentException("key is already used: [key=" + key + ", className=" + className + "]");
            }
        } else {
            throw new IllegalArgumentException("all args are mandatory: [key=" + key + ", className=" + className + "]");
        }
        this.mappingClasses.put(key, className);
        this.mappingReps.put(key, className);
    }

    @Override
    public void registerEntity(String key, String className, String representative) throws IllegalArgumentException {
        if (key != null && key.length() > 0 && className != null && className.length() > 0 && representative != null && representative.length() > 0) {
            if (this.mappingClasses.containsKey(key)) {
                throw new IllegalArgumentException("key is already used: [key=" + key + ", className=" + className + "]");
            }
        } else {
            throw new IllegalArgumentException("all args are mandatory: [key=" + key + ", className=" + className + ", rep=" + representative + "]");
        }
        this.mappingClasses.put(key, className);
        this.mappingReps.put(key, representative);
    }

    @Override
    public Class getClazz(String entityBeanKey) {
        return this.getClassFromMapping(entityBeanKey, this.mappingReps, this.cacheReps);
    }

    @Override
    public Object get(String entityBeanKey) {
        Class clazz = this.getClassFromMapping(entityBeanKey, this.mappingClasses, this.cacheClasses);
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exp) {
                LOG.error("Unable to create instance for key = {}", (Object)entityBeanKey);
                LOG.error(exp.getMessage(), (Throwable)exp);
            }
        }
        return null;
    }

    private Class getClassFromMapping(String entityBeanKey, Map<String, String> mapping, Map<String, Class> cache) {
        if (entityBeanKey != null && entityBeanKey.length() > 0) {
            if (cache.containsKey(entityBeanKey)) {
                return cache.get(entityBeanKey);
            }
            String className = mapping.get(entityBeanKey);
            if (className != null) {
                try {
                    Class<?> clazz = Class.forName(className, true, this.classLoader.get());
                    cache.put(entityBeanKey, clazz);
                    return clazz;
                }
                catch (Exception exp) {
                    LOG.error("Unable to create class for key = {}", (Object)entityBeanKey);
                    LOG.error(exp.getMessage(), (Throwable)exp);
                }
            } else {
                LOG.error("No mapping for key = {}", (Object)entityBeanKey);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResources() {
        ClassLoaderBeanFactory classLoaderBeanFactory = this;
        synchronized (classLoaderBeanFactory) {
            this.mappingClasses.clear();
            this.mappingReps.clear();
            this.cacheClasses.clear();
            this.cacheReps.clear();
            this.classLoader.clear();
        }
    }
}

