/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.adapter.repository.impl;

import com.inspiresoftware.lib.dto.geda.adapter.repository.AdaptersRepository;
import com.inspiresoftware.lib.dto.geda.exception.DuplicateValueConverterKeyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptersRepositoryImpl
implements AdaptersRepository {
    private static final long serialVersionUID = 20100126L;
    private final Map<String, Object> repository = new ConcurrentHashMap<String, Object>();

    public AdaptersRepositoryImpl() {
    }

    public AdaptersRepositoryImpl(Map<String, Object> repository) {
        this.repository.putAll(repository);
    }

    @Override
    public Map<String, Object> getAll() {
        return Collections.unmodifiableMap(this.repository);
    }

    @Override
    public <T> T getByKey(String key) {
        return (T)this.repository.get(key);
    }

    @Override
    public Map<String, Object> getByKeysAsMap(String ... keys) {
        HashMap<String, Object> repo = new HashMap<String, Object>();
        if (keys != null) {
            for (String key : keys) {
                Object conv = this.getByKey(key);
                if (conv == null) continue;
                repo.put(key, conv);
            }
        }
        return repo;
    }

    @Override
    public void registerAdapterForced(String key, Object adapter) {
        this.repository.put(key, adapter);
    }

    @Override
    public void registerAdapter(String key, Object adapter) throws DuplicateValueConverterKeyException {
        if (this.repository.containsKey(key)) {
            throw new DuplicateValueConverterKeyException(key);
        }
        this.registerAdapterForced(key, adapter);
    }

    @Override
    public void removeAdapter(String key) {
        this.repository.remove(key);
    }

    @Override
    public void releaseResources() {
        this.repository.clear();
    }
}

