/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.assembler.meta.PipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToLocateRepresentationException;

class BasePipeMetadata
implements PipeMetadata {
    private final String dtoFieldName;
    private final String entityFieldName;
    private final boolean readOnly;
    private final String dtoBeanKey;
    private final String entityBeanKey;

    public BasePipeMetadata(String dtoFieldName, String entityFieldName, String dtoBeanKey, String entityBeanKey, boolean readOnly) {
        this.dtoFieldName = dtoFieldName;
        this.entityFieldName = entityFieldName;
        this.dtoBeanKey = dtoBeanKey;
        this.entityBeanKey = entityBeanKey;
        this.readOnly = readOnly;
    }

    public String getDtoFieldName() {
        return this.dtoFieldName;
    }

    public String getEntityFieldName() {
        return this.entityFieldName;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getDtoBeanKey() {
        return this.dtoBeanKey;
    }

    public Object newDtoBean(BeanFactory factory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException {
        return this.newBean(this.getDtoBeanKey(), factory, true);
    }

    public String getEntityBeanKey() {
        return this.entityBeanKey;
    }

    public Object newEntityBean(BeanFactory factory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException {
        return this.newBean(this.getEntityBeanKey(), factory, false);
    }

    protected Class getRepresentation(String beanKey, BeanFactory factory, boolean isDto) throws BeanFactoryNotFoundException, BeanFactoryUnableToLocateRepresentationException {
        if (factory == null) {
            if (isDto) {
                throw new BeanFactoryNotFoundException(this.dtoFieldName, beanKey, true);
            }
            throw new BeanFactoryNotFoundException(this.entityFieldName, beanKey, false);
        }
        Class representation = factory.getClazz(beanKey);
        if (representation == null) {
            if (isDto) {
                throw new BeanFactoryUnableToLocateRepresentationException(factory.toString(), this.dtoFieldName, beanKey, true);
            }
            throw new BeanFactoryUnableToLocateRepresentationException(factory.toString(), this.entityFieldName, beanKey, false);
        }
        return representation;
    }

    protected Object newBean(String beanKey, BeanFactory factory, boolean isDto) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException {
        if (factory == null) {
            if (isDto) {
                throw new BeanFactoryNotFoundException(this.dtoFieldName, this.dtoBeanKey, true);
            }
            throw new BeanFactoryNotFoundException(this.entityFieldName, this.entityBeanKey, false);
        }
        Object newObject = factory.get(beanKey);
        if (newObject == null) {
            if (isDto) {
                throw new BeanFactoryUnableToCreateInstanceException(factory.toString(), this.dtoFieldName, this.dtoBeanKey, true);
            }
            throw new BeanFactoryUnableToCreateInstanceException(factory.toString(), this.entityFieldName, this.entityBeanKey, false);
        }
        return newObject;
    }
}

