/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.adapter.DtoToEntityMatcher;
import com.inspiresoftware.lib.dto.geda.assembler.Assembler;
import com.inspiresoftware.lib.dto.geda.assembler.AssemblerContext;
import com.inspiresoftware.lib.dto.geda.assembler.Pipe;
import com.inspiresoftware.lib.dto.geda.assembler.PipeValidator;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.meta.CollectionPipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationDuplicateBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBeanKeyException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationMissingException;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToLocateRepresentationException;
import com.inspiresoftware.lib.dto.geda.exception.CollectionEntityGenericReturnTypeException;
import com.inspiresoftware.lib.dto.geda.exception.DtoToEntityMatcherNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.EntityRetrieverNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidDtoInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionInvalidEntityInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionScanningException;
import com.inspiresoftware.lib.dto.geda.exception.NotDtoToEntityMatcherException;
import com.inspiresoftware.lib.dto.geda.exception.NotEntityRetrieverException;
import com.inspiresoftware.lib.dto.geda.exception.NotValueConverterException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import com.inspiresoftware.lib.dto.geda.exception.ValueConverterNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionPipe
implements Pipe {
    private final CollectionPipeMetadata meta;
    private final AssemblerContext context;
    private final DataReader dtoRead;
    private final DataWriter dtoWrite;
    private final DataReader entityRead;
    private final DataWriter entityWrite;

    CollectionPipe(AssemblerContext context, DataReader dtoRead, DataWriter dtoWrite, DataReader entityRead, DataWriter entityWrite, CollectionPipeMetadata meta) throws AnnotationValidatingBindingException {
        this.meta = meta;
        this.context = context;
        this.dtoWrite = dtoWrite;
        this.entityRead = entityRead;
        if (this.meta.isReadOnly()) {
            this.dtoRead = null;
            this.entityWrite = null;
            PipeValidator.validateReadPipeTypes(context.getDslRegistry(), this.dtoWrite, this.meta.getDtoFieldName(), this.entityRead, this.meta.getEntityFieldName());
        } else {
            this.dtoRead = dtoRead;
            this.entityWrite = entityWrite;
            PipeValidator.validatePipeTypes(context.getDslRegistry(), this.dtoRead, this.dtoWrite, this.meta.getDtoFieldName(), this.entityRead, this.entityWrite, this.meta.getEntityFieldName());
        }
    }

    @Override
    public String getBinding() {
        return this.meta.getEntityFieldName();
    }

    @Override
    public void writeFromEntityToDto(Object entity, Object dto, Map<String, Object> converters, BeanFactory dtoBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, UnableToCreateInstanceException, CollectionEntityGenericReturnTypeException, AnnotationMissingException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, NotValueConverterException, ValueConverterNotFoundException {
        Object entityCollection = this.entityRead.read(entity);
        if (entityCollection instanceof Collection) {
            Collection entities = (Collection)entityCollection;
            Collection dtos = this.meta.newDtoCollection(dtoBeanFactory);
            Class<?> entityRepresentative = this.meta.getReturnType(dtoBeanFactory);
            Object newDto = this.meta.newDtoBean(dtoBeanFactory);
            try {
                Assembler assembler = null;
                for (Object object : entities) {
                    assembler = this.lazyCreateAssembler(assembler, newDto, object, dtoBeanFactory);
                    assembler.assembleDto(newDto, object, converters, dtoBeanFactory);
                    dtos.add(newDto);
                    newDto = this.meta.newDtoBean(dtoBeanFactory);
                }
                this.dtoWrite.write(dto, dtos);
            }
            catch (BeanFactoryUnableToLocateRepresentationException bfulr) {
                throw new CollectionEntityGenericReturnTypeException(newDto.getClass().getCanonicalName(), this.meta.getDtoFieldName(), "Not found for key provided");
            }
            catch (InspectionInvalidDtoInstanceException invDto) {
                throw new CollectionEntityGenericReturnTypeException(newDto.getClass().getCanonicalName(), this.meta.getDtoFieldName(), entityRepresentative != null ? entityRepresentative.getCanonicalName() : "unspecified");
            }
            catch (InspectionInvalidEntityInstanceException invEntity) {
                throw new CollectionEntityGenericReturnTypeException(newDto.getClass().getCanonicalName(), this.meta.getDtoFieldName(), entityRepresentative != null ? entityRepresentative.getCanonicalName() : "unspecified");
            }
        }
    }

    @Override
    public void writeFromDtoToEntity(Object entityObj, Object dto, Map<String, Object> converters, BeanFactory entityBeanFactory) throws BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, UnableToCreateInstanceException, CollectionEntityGenericReturnTypeException, AnnotationMissingException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        Object originalEntityColl;
        if (this.meta.isReadOnly()) {
            return;
        }
        Object dtoColl = this.dtoRead.read(dto);
        if (dtoColl instanceof Collection) {
            Object entity = entityObj;
            Object originalEntityColl2 = this.entityRead.read(entity);
            Collection original = null;
            if (originalEntityColl2 instanceof Collection) {
                original = (Collection)originalEntityColl2;
            } else {
                original = this.meta.newEntityCollection(entityBeanFactory);
                this.entityWrite.write(entity, original);
            }
            Collection dtos = (Collection)dtoColl;
            this.removeDeletedItems(original, dtos, converters, entityBeanFactory);
            this.addOrUpdateItems(dto, converters, entityBeanFactory, original, dtos);
        } else if (entityObj != null && (originalEntityColl = this.entityRead.read(entityObj)) instanceof Collection) {
            ((Collection)originalEntityColl).clear();
        }
    }

    private Assembler lazyCreateAssembler(Assembler assembler, Object dtoItem, Object entityItem, BeanFactory beanFactory) throws CollectionEntityGenericReturnTypeException, AnnotationMissingException, InspectionScanningException, UnableToCreateInstanceException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException {
        if (assembler == null) {
            Class<?> representative = this.meta.getReturnType(beanFactory);
            if (Object.class.equals(representative) && entityItem != null) {
                representative = entityItem.getClass();
            }
            try {
                if (Object.class.equals(representative)) {
                    throw new CollectionEntityGenericReturnTypeException(dtoItem.getClass().getCanonicalName(), this.meta.getDtoFieldName(), representative.getCanonicalName());
                }
                return this.context.newAssembler(dtoItem.getClass(), representative);
            }
            catch (InspectionInvalidEntityInstanceException invEntity) {
                throw new CollectionEntityGenericReturnTypeException(dtoItem.getClass().getCanonicalName(), this.meta.getDtoFieldName(), representative != null ? representative.getCanonicalName() : "unspecified");
            }
            catch (InspectionInvalidDtoInstanceException invDto) {
                throw new CollectionEntityGenericReturnTypeException(dtoItem.getClass().getCanonicalName(), this.meta.getDtoFieldName(), representative != null ? representative.getCanonicalName() : "unspecified");
            }
        }
        return assembler;
    }

    private void addOrUpdateItems(Object dto, Map<String, Object> converters, BeanFactory entityBeanFactory, Collection original, Collection dtos) throws CollectionEntityGenericReturnTypeException, AnnotationMissingException, BeanFactoryNotFoundException, BeanFactoryUnableToCreateInstanceException, InspectionInvalidDtoInstanceException, InspectionInvalidEntityInstanceException, NotEntityRetrieverException, EntityRetrieverNotFoundException, NotValueConverterException, ValueConverterNotFoundException, AnnotationMissingBeanKeyException, UnableToCreateInstanceException, InspectionScanningException, InspectionPropertyNotFoundException, InspectionBindingNotFoundException, AnnotationMissingBindingException, AnnotationValidatingBindingException, GeDARuntimeException, AnnotationDuplicateBindingException, DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        Assembler assembler = null;
        DtoToEntityMatcher matcher = this.meta.getDtoToEntityMatcher(converters);
        for (Object dtoItem : dtos) {
            boolean toAdd = true;
            for (Object orItem : original) {
                if (!matcher.match(dtoItem, orItem)) continue;
                assembler = this.lazyCreateAssembler(assembler, dtoItem, orItem, entityBeanFactory);
                assembler.assembleEntity(dtoItem, orItem, converters, entityBeanFactory);
                toAdd = false;
                break;
            }
            if (!toAdd) continue;
            Object newItem = this.meta.newEntityBean(entityBeanFactory);
            assembler = this.lazyCreateAssembler(assembler, dtoItem, newItem, entityBeanFactory);
            assembler.assembleEntity(dtoItem, newItem, converters, entityBeanFactory);
            original.add(newItem);
        }
    }

    private void removeDeletedItems(Collection original, Collection dtos, Map<String, Object> converters, BeanFactory entityBeanFactory) throws DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        DtoToEntityMatcher matcher = this.meta.getDtoToEntityMatcher(converters);
        Iterator orIt = original.iterator();
        while (orIt.hasNext()) {
            Object orItem = orIt.next();
            boolean isRemoved = true;
            for (Object dtoItem : dtos) {
                if (!matcher.match(dtoItem, orItem)) continue;
                isRemoved = false;
                break;
            }
            if (!isRemoved) continue;
            orIt.remove();
        }
    }
}

