/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.assembler.AssemblerContext;
import com.inspiresoftware.lib.dto.geda.assembler.BasePipeBuilder;
import com.inspiresoftware.lib.dto.geda.assembler.CollectionPipe;
import com.inspiresoftware.lib.dto.geda.assembler.Pipe;
import com.inspiresoftware.lib.dto.geda.assembler.PropertyInspector;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataReader;
import com.inspiresoftware.lib.dto.geda.assembler.extension.DataWriter;
import com.inspiresoftware.lib.dto.geda.assembler.extension.MethodSynthesizer;
import com.inspiresoftware.lib.dto.geda.assembler.meta.CollectionPipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.AnnotationValidatingBindingException;
import com.inspiresoftware.lib.dto.geda.exception.GeDARuntimeException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionBindingNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.InspectionPropertyNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionPipeBuilder
extends BasePipeBuilder<CollectionPipeMetadata> {
    CollectionPipeBuilder() {
    }

    @Override
    public Pipe build(AssemblerContext context, Class dtoClass, Class entityClass, PropertyDescriptor[] dtoPropertyDescriptors, PropertyDescriptor[] entityPropertyDescriptors, CollectionPipeMetadata meta, Pipe pipe) throws InspectionBindingNotFoundException, InspectionPropertyNotFoundException, UnableToCreateInstanceException, AnnotationValidatingBindingException, GeDARuntimeException {
        PropertyDescriptor entityFieldDesc;
        MethodSynthesizer entitySynthesizer;
        boolean isListEntity;
        PropertyDescriptor dtoFieldDesc = PropertyInspector.getDtoPropertyDescriptorForField(dtoClass, meta.getDtoFieldName(), dtoPropertyDescriptors);
        MethodSynthesizer synthesizer = context.getMethodSynthesizer();
        DataReader dtoFieldRead = meta.isReadOnly() ? null : synthesizer.synthesizeReader(dtoFieldDesc);
        DataWriter dtoFieldWrite = synthesizer.synthesizeWriter(dtoFieldDesc);
        boolean isMapEntity = Map.class.isAssignableFrom(entityClass);
        boolean bl = isListEntity = !isMapEntity && List.class.isAssignableFrom(entityClass);
        if (isMapEntity || isListEntity) {
            entitySynthesizer = isMapEntity ? mapSynthesizer : listSynthesizer;
            entityFieldDesc = dtoFieldDesc;
        } else {
            entitySynthesizer = synthesizer;
            entityFieldDesc = PropertyInspector.getEntityPropertyDescriptorForField(dtoClass, entityClass, meta.getDtoFieldName(), meta.getEntityFieldName(), entityPropertyDescriptors);
        }
        DataReader entityFieldRead = entitySynthesizer.synthesizeReader(entityFieldDesc);
        DataWriter entityFieldWrite = meta.isReadOnly() ? null : entitySynthesizer.synthesizeWriter(entityFieldDesc);
        return new CollectionPipe(context, dtoFieldRead, dtoFieldWrite, entityFieldRead, entityFieldWrite, meta);
    }
}

