/*
 * Decompiled with CFR 0.152.
 */
package com.inspiresoftware.lib.dto.geda.assembler;

import com.inspiresoftware.lib.dto.geda.adapter.BeanFactory;
import com.inspiresoftware.lib.dto.geda.adapter.DtoToEntityMatcher;
import com.inspiresoftware.lib.dto.geda.assembler.BasePipeMetadata;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.BeanFactoryUnableToLocateRepresentationException;
import com.inspiresoftware.lib.dto.geda.exception.DtoToEntityMatcherNotFoundException;
import com.inspiresoftware.lib.dto.geda.exception.NotDtoToEntityMatcherException;
import com.inspiresoftware.lib.dto.geda.exception.UnableToCreateInstanceException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionPipeMetadata
extends BasePipeMetadata
implements com.inspiresoftware.lib.dto.geda.assembler.meta.CollectionPipeMetadata {
    private static final Map<Class, DtoToEntityMatcher> CACHE = new HashMap<Class, DtoToEntityMatcher>();
    private final Class<? extends Collection> dtoCollectionClass;
    private final String dtoCollectionClassKey;
    private final Class<? extends Collection> entityCollectionClass;
    private final String entityCollectionClassKey;
    private final Class<?> returnType;
    private final String returnTypeKey;
    private final DtoToEntityMatcher dtoToEntityMatcher;
    private final String dtoToEntityMatcherKey;

    public CollectionPipeMetadata(String dtoFieldName, String entityFieldName, String dtoBeanKey, String entityBeanKey, boolean readOnly, Class<? extends Collection> dtoCollectionClass, String dtoCollectionClassKey, Class<? extends Collection> entityCollectionClass, String entityCollectionClassKey, Class<?> returnType, String returnTypeKey, Class<? extends DtoToEntityMatcher> dtoToEntityMatcherClass, String dtoToEntityMatcherKey) throws UnableToCreateInstanceException {
        super(dtoFieldName, entityFieldName, dtoBeanKey, entityBeanKey, readOnly);
        this.dtoCollectionClass = dtoCollectionClass;
        this.returnTypeKey = returnTypeKey != null && returnTypeKey.length() > 0 ? returnTypeKey : null;
        this.dtoCollectionClassKey = dtoCollectionClassKey != null && dtoCollectionClassKey.length() > 0 ? dtoCollectionClassKey : null;
        this.entityCollectionClass = entityCollectionClass;
        this.entityCollectionClassKey = entityCollectionClassKey != null && entityCollectionClassKey.length() > 0 ? entityCollectionClassKey : null;
        this.returnType = returnType;
        if (dtoToEntityMatcherKey == null || dtoToEntityMatcherKey.length() == 0) {
            if (CACHE.containsKey(dtoToEntityMatcherClass)) {
                this.dtoToEntityMatcher = CACHE.get(dtoToEntityMatcherClass);
            } else {
                this.dtoToEntityMatcher = this.newBeanForClass(dtoToEntityMatcherClass, "Unable to create matcher: {0} for: {1} - {2}", dtoToEntityMatcherClass, this.getDtoBeanKey(), this.getEntityBeanKey());
                CACHE.put(dtoToEntityMatcherClass, this.dtoToEntityMatcher);
            }
            this.dtoToEntityMatcherKey = null;
        } else {
            this.dtoToEntityMatcher = null;
            this.dtoToEntityMatcherKey = dtoToEntityMatcherKey;
        }
    }

    @Override
    public Collection newDtoCollection(BeanFactory beanFactory) throws UnableToCreateInstanceException, BeanFactoryNotFoundException {
        if (this.dtoCollectionClassKey != null) {
            return this.newCollection(this.dtoCollectionClassKey, beanFactory, true);
        }
        return this.newCollection(this.dtoCollectionClass, " Dto field: ", this.getDtoFieldName());
    }

    @Override
    public Collection newEntityCollection(BeanFactory beanFactory) throws UnableToCreateInstanceException, BeanFactoryNotFoundException {
        if (this.entityCollectionClassKey != null) {
            return this.newCollection(this.entityCollectionClassKey, beanFactory, false);
        }
        return this.newCollection(this.entityCollectionClass, " Entity field: ", this.getEntityFieldName());
    }

    @Override
    public Class<?> getReturnType(BeanFactory beanFactory) throws BeanFactoryUnableToLocateRepresentationException, BeanFactoryNotFoundException {
        if (this.returnTypeKey == null) {
            return this.returnType;
        }
        return this.getRepresentation(this.returnTypeKey, beanFactory, false);
    }

    @Override
    public DtoToEntityMatcher getDtoToEntityMatcher(Map<String, Object> converters) throws DtoToEntityMatcherNotFoundException, NotDtoToEntityMatcherException {
        if (this.dtoToEntityMatcherKey == null) {
            return this.dtoToEntityMatcher;
        }
        if (converters == null) {
            throw new DtoToEntityMatcherNotFoundException(this.getDtoFieldName(), this.getEntityFieldName(), this.dtoToEntityMatcherKey);
        }
        Object matcher = converters.get(this.dtoToEntityMatcherKey);
        if (matcher == null) {
            throw new DtoToEntityMatcherNotFoundException(this.getDtoFieldName(), this.getEntityFieldName(), this.dtoToEntityMatcherKey);
        }
        if (matcher instanceof DtoToEntityMatcher) {
            return (DtoToEntityMatcher)matcher;
        }
        throw new NotDtoToEntityMatcherException(this.getDtoFieldName(), this.getEntityFieldName(), this.dtoToEntityMatcherKey);
    }

    private Collection newCollection(String clazzKey, BeanFactory beanFactory, boolean isDto) throws UnableToCreateInstanceException, BeanFactoryNotFoundException {
        if (beanFactory == null) {
            throw new BeanFactoryNotFoundException(this.getDtoFieldName(), clazzKey, isDto);
        }
        Object coll = beanFactory.get(clazzKey);
        if (coll instanceof Collection) {
            return (Collection)coll;
        }
        throw new UnableToCreateInstanceException(clazzKey, " Collection" + (isDto ? " Dto" : " Entity") + " field: " + this.getDtoFieldName() + "@key:" + clazzKey + " (Check if beanFactory [" + beanFactory + "] returns a correct instance)", null);
    }

    private Collection newCollection(Class<? extends Collection> clazz, String type, String field) throws UnableToCreateInstanceException {
        return this.newBeanForClass(clazz, "Unable to create collection: {0} for {1} {2}", clazz, type, field);
    }

    private <T> T newBeanForClass(Class<T> clazz, String errMsg, Object ... msgParams) throws UnableToCreateInstanceException {
        try {
            return clazz.newInstance();
        }
        catch (Exception iex) {
            throw new UnableToCreateInstanceException(clazz.getCanonicalName(), String.format(errMsg, msgParams), iex);
        }
    }
}

